rule win_unidentified_109_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.unidentified_109."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_109"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 48039790020000 e8???????? 428d0433 488b5c2460 898798020000 2bc6 85ed }
            // n = 7, score = 100
            //   48039790020000       | sub                 eax, esi
            //   e8????????           |                     
            //   428d0433             | inc                 esp
            //   488b5c2460           | movzx               edi, cx
            //   898798020000         | inc                 ecx
            //   2bc6                 | add                 eax, edi
            //   85ed                 | shl                 cx, 8

        $sequence_1 = { 0f8546020000 e9???????? 488d542420 488d4c2420 e8???????? 8bd8 c744242800000000 }
            // n = 7, score = 100
            //   0f8546020000         | cmp                 dword ptr [ebx], 0
            //   e9????????           |                     
            //   488d542420           | inc                 ecx
            //   488d4c2420           | mov                 edx, ecx
            //   e8????????           |                     
            //   8bd8                 | dec                 eax
            //   c744242800000000     | test                ebx, ebx

        $sequence_2 = { 488b4210 416bf81c 83ef1c 428b5480fc 85d2 740d }
            // n = 6, score = 100
            //   488b4210             | movzx               ecx, al
            //   416bf81c             | lea                 eax, [edx + ecx]
            //   83ef1c               | cmp                 eax, edi
            //   428b5480fc           | ja                  0x142f
            //   85d2                 | jmp                 0x13c5
            //   740d                 | inc                 ecx

        $sequence_3 = { 488978d8 8978e0 8b4208 458d4a01 8bef 394108 }
            // n = 6, score = 100
            //   488978d8             | mov                 ecx, eax
            //   8978e0               | test                eax, eax
            //   8b4208               | jne                 0x13f8
            //   458d4a01             | dec                 eax
            //   8bef                 | mov                 ecx, dword ptr [edi + 0x10]
            //   394108               | mov                 ecx, eax

        $sequence_4 = { 85c0 0f8562fdffff 488b4710 488b4808 0fb68776020000 8801 488b4710 }
            // n = 7, score = 100
            //   85c0                 | inc                 ebp
            //   0f8562fdffff         | test                ebx, ebx
            //   488b4710             | js                  0x28b
            //   488b4808             | dec                 eax
            //   0fb68776020000       | mov                 ecx, dword ptr [ebx + 0x290]
            //   8801                 | dec                 esp
            //   488b4710             | lea                 eax, [ebx + 0x20]

        $sequence_5 = { 4833c8 4823cd 4833ca 48c1c120 498948f8 49ffc9 75b6 }
            // n = 7, score = 100
            //   4833c8               | sub                 eax, 4
            //   4823cd               | inc                 ecx
            //   4833ca               | cmp                 ecx, esi
            //   48c1c120             | jl                  0x1729
            //   498948f8             | dec                 esp
            //   49ffc9               | lea                 eax, [ebp - 0x59]
            //   75b6                 | jb                  0x1795

        $sequence_6 = { 8d5883 e9???????? 448b6d97 c6879803000001 c7456701000000 4585ed 0f8e3c020000 }
            // n = 7, score = 100
            //   8d5883               | or                  eax, edx
            //   e9????????           |                     
            //   448b6d97             | rol                 edx, 0xa
            //   c6879803000001       | inc                 ecx
            //   c7456701000000       | rol                 eax, 9
            //   4585ed               | inc                 ecx
            //   0f8e3c020000         | add                 eax, dword ptr [ebx + 0x44]

        $sequence_7 = { 0f8747040000 418bc0 803c1830 0f853a040000 418d4901 418bd4 3bcd }
            // n = 7, score = 100
            //   0f8747040000         | dec                 eax
            //   418bc0               | mov                 dword ptr [esp + 0x38], eax
            //   803c1830             | dec                 eax
            //   0f853a040000         | mov                 dword ptr [ebp - 0x79], eax
            //   418d4901             | dec                 eax
            //   418bd4               | mov                 dword ptr [ebp - 0x71], eax
            //   3bcd                 | dec                 esp

        $sequence_8 = { 41ffc8 75ed eb04 410fb6c8 8d040a 413bc3 0f877c010000 }
            // n = 7, score = 100
            //   41ffc8               | mov                 dword ptr [ebp - 9], esp
            //   75ed                 | inc                 esp
            //   eb04                 | mov                 dword ptr [ebp - 1], esp
            //   410fb6c8             | dec                 esp
            //   8d040a               | mov                 dword ptr [ebp - 0x41], esp
            //   413bc3               | dec                 esp
            //   0f877c010000         | mov                 dword ptr [ebp + 0x1f], esp

        $sequence_9 = { 80b97502000001 7304 3cfe 7517 488b8950090000 488d542430 }
            // n = 6, score = 100
            //   80b97502000001       | inc                 ecx
            //   7304                 | push                esi
            //   3cfe                 | dec                 eax
            //   7517                 | sub                 esp, 0x58
            //   488b8950090000       | inc                 esp
            //   488d542430           | mov                 edx, dword ptr [ecx]

    condition:
        7 of them and filesize < 723968
}