rule win_unidentified_112_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.unidentified_112."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_112"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { f20f70dbd4 660f70dbd4 660fdbda 660fd4c3 4883c002 4839c2 75d3 }
            // n = 7, score = 100
            //   f20f70dbd4           | dec                 eax
            //   660f70dbd4           | lea                 ebp, [ecx - 0x50]
            //   660fdbda             | dec                 eax
            //   660fd4c3             | lea                 ebx, [esi + 0x10]
            //   4883c002             | pcmpeqd             xmm7, xmm7
            //   4839c2               | xor                 eax, eax
            //   75d3                 | pshuflw             xmm0, xmm0, 0

        $sequence_1 = { e9???????? 0fb615???????? 84d2 0f8456fcffff 0fb6c2 83f801 0f8426010000 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   0fb615????????       |                     
            //   84d2                 | mov                 eax, 0x118
            //   0f8456fcffff         | dec                 eax
            //   0fb6c2               | mov                 ecx, ebx
            //   83f801               | movups              xmm6, xmmword ptr [ebp + 0x16c8]
            //   0f8426010000         | dec                 eax

        $sequence_2 = { eb7e b107 488955f0 884e01 c60603 3c02 723a }
            // n = 7, score = 100
            //   eb7e                 | mov                 dword ptr [esp + 0x20], eax
            //   b107                 | dec                 eax
            //   488955f0             | lea                 ecx, [0x100a84]
            //   884e01               | dec                 esp
            //   c60603               | lea                 ecx, [0x100998]
            //   3c02                 | jmp                 0x2e0
            //   723a                 | movzx               ecx, byte ptr [ebp - 0x3d]

        $sequence_3 = { ff10 488b4500 488b5008 4885d2 488b7df0 488b4df8 7409 }
            // n = 7, score = 100
            //   ff10                 | mov                 eax, eax
            //   488b4500             | inc                 ecx
            //   488b5008             | sub                 eax, ecx
            //   4885d2               | inc                 esp
            //   488b7df0             | cmovb               eax, edx
            //   488b4df8             | inc                 ecx
            //   7409                 | cmp                 eax, 3

        $sequence_4 = { eb10 eb0e 0fb7474c 0fb74df8 66894f4c 31db 89c1 }
            // n = 7, score = 100
            //   eb10                 | jmp                 0xda
            //   eb0e                 | mov                 ecx, 8
            //   0fb7474c             | mov                 edx, 0x70
            //   0fb74df8             | ud2                 
            //   66894f4c             | nop                 word ptr cs:[eax + eax]
            //   31db                 | dec                 eax
            //   89c1                 | mov                 dword ptr [esp + 0x10], edx

        $sequence_5 = { ff15???????? 488bbdc8040000 488b9d70050000 488b8d80050000 ff15???????? 4883bd9005000000 740d }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   488bbdc8040000       | je                  0xa42
            //   488b9d70050000       | call                dword ptr [eax]
            //   488b8d80050000       | dec                 eax
            //   ff15????????         |                     
            //   4883bd9005000000     | lea                 ecx, [edx + 0x118]
            //   740d                 | dec                 eax

        $sequence_6 = { 751c 83f801 0f8574ffffff b8ffffffff 4883c420 5b c3 }
            // n = 7, score = 100
            //   751c                 | or                  eax, 2
            //   83f801               | dec                 eax
            //   0f8574ffffff         | mov                 dword ptr [esi], eax
            //   b8ffffffff           | dec                 eax
            //   4883c420             | mov                 dword ptr [esi + 0x10], 2
            //   5b                   | dec                 eax
            //   c3                   | test                ebx, ebx

        $sequence_7 = { ffe0 41c684246001000001 4d8b742410 4d8b7c2418 488d8db0030000 e8???????? 488d8db0030000 }
            // n = 7, score = 100
            //   ffe0                 | call                eax
            //   41c684246001000001     | jmp    0xffffffd7
            //   4d8b742410           | dec                 eax
            //   4d8b7c2418           | lea                 ecx, [ebp - 0x58]
            //   488d8db0030000       | nop                 
            //   e8????????           |                     
            //   488d8db0030000       | dec                 eax

        $sequence_8 = { ffc8 418987fc280000 83f803 0f823efbffff 89c1 4c8d05ad431200 ba03000000 }
            // n = 7, score = 100
            //   ffc8                 | ja                  0x224
            //   418987fc280000       | dec                 eax
            //   83f803               | mov                 eax, dword ptr [esp + 0xe8]
            //   0f823efbffff         | dec                 eax
            //   89c1                 | mov                 dword ptr [eax], edi
            //   4c8d05ad431200       | dec                 eax
            //   ba03000000           | mov                 dword ptr [eax + 8], ebp

        $sequence_9 = { eb56 0f10b708050000 488b9f08050000 48c7870805000003000000 4883fb03 0f8493000000 488d4da0 }
            // n = 7, score = 100
            //   eb56                 | jmp                 0xd1
            //   0f10b708050000       | mov                 byte ptr [ebp + 0x317], 1
            //   488b9f08050000       | dec                 eax
            //   48c7870805000003000000     | lea    ecx, [0x1bca33]
            //   4883fb03             | dec                 esp
            //   0f8493000000         | lea                 eax, [0x1be318]
            //   488d4da0             | mov                 edx, 0x22

    condition:
        7 of them and filesize < 7317504
}