rule win_urausy_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.urausy."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.urausy"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 33c0 c9 c20800 8d45ec 50 }
            // n = 6, score = 200
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax
            //   c9                   | leave               
            //   c20800               | ret                 8
            //   8d45ec               | lea                 eax, [ebp - 0x14]
            //   50                   | push                eax

        $sequence_1 = { 8d8500feffff 50 e8???????? 83f800 }
            // n = 4, score = 200
            //   8d8500feffff         | lea                 eax, [ebp - 0x200]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83f800               | cmp                 eax, 0

        $sequence_2 = { ff75e4 e8???????? 8945e8 ff35???????? }
            // n = 4, score = 200
            //   ff75e4               | push                dword ptr [ebp - 0x1c]
            //   e8????????           |                     
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   ff35????????         |                     

        $sequence_3 = { 6894020000 ff75e8 ff75ec 6800000050 }
            // n = 4, score = 200
            //   6894020000           | push                0x294
            //   ff75e8               | push                dword ptr [ebp - 0x18]
            //   ff75ec               | push                dword ptr [ebp - 0x14]
            //   6800000050           | push                0x50000000

        $sequence_4 = { e8???????? 8945e8 8945fc 68007f0000 6a00 e8???????? }
            // n = 6, score = 200
            //   e8????????           |                     
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   68007f0000           | push                0x7f00
            //   6a00                 | push                0
            //   e8????????           |                     

        $sequence_5 = { 6a00 68???????? e8???????? 85c0 0f8461010000 }
            // n = 5, score = 200
            //   6a00                 | push                0
            //   68????????           |                     
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f8461010000         | je                  0x167

        $sequence_6 = { e8???????? 833d????????01 0f8599030000 68d4070000 ff35???????? e8???????? a3???????? }
            // n = 7, score = 200
            //   e8????????           |                     
            //   833d????????01       |                     
            //   0f8599030000         | jne                 0x39f
            //   68d4070000           | push                0x7d4
            //   ff35????????         |                     
            //   e8????????           |                     
            //   a3????????           |                     

        $sequence_7 = { 68b80b0000 e8???????? c9 c20400 }
            // n = 4, score = 200
            //   68b80b0000           | push                0xbb8
            //   e8????????           |                     
            //   c9                   | leave               
            //   c20400               | ret                 4

        $sequence_8 = { 6a0f e8???????? 8945e4 8345ec61 8345e82d 6a00 ff35???????? }
            // n = 7, score = 200
            //   6a0f                 | push                0xf
            //   e8????????           |                     
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   8345ec61             | add                 dword ptr [ebp - 0x14], 0x61
            //   8345e82d             | add                 dword ptr [ebp - 0x18], 0x2d
            //   6a00                 | push                0
            //   ff35????????         |                     

        $sequence_9 = { eb1b 3d57000780 7502 eb12 }
            // n = 4, score = 200
            //   eb1b                 | jmp                 0x1d
            //   3d57000780           | cmp                 eax, 0x80070057
            //   7502                 | jne                 4
            //   eb12                 | jmp                 0x14

    condition:
        7 of them and filesize < 98304
}