rule win_valuevault_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.valuevault"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 760b 83e836 83f002 83c036 }
            // n = 4, score = 200
            //   760b                 | add                 ebp, 8
            //   83e836               | dec                 ecx
            //   83f002               | mov                 eax, dword ptr [esp + 0x10]
            //   83c036               | jle                 0x1acc

        $sequence_1 = { e8???????? 0f0b e8???????? 0f0b 0f0b }
            // n = 5, score = 200
            //   e8????????           |                     
            //   0f0b                 | lea                 eax, [0x6305c0]
            //   e8????????           |                     
            //   0f0b                 | mov                 dword ptr [esp], eax
            //   0f0b                 | mov                 eax, dword ptr [esp + 0x1c]

        $sequence_2 = { 85c0 740a 83f806 7405 83f805 }
            // n = 5, score = 200
            //   85c0                 | dec                 eax
            //   740a                 | mov                 ecx, dword ptr [0x28]
            //   83f806               | dec                 eax
            //   7405                 | mov                 ecx, dword ptr [ecx]
            //   83f805               | dec                 eax

        $sequence_3 = { c7436000000000 c7838000000000000000 c7436800000000 c7436cffffffff c74370ffffffff }
            // n = 5, score = 200
            //   c7436000000000       | mov                 eax, dword ptr [esp + 0x1ac]
            //   c7838000000000000000     | mov    esi, dword ptr [esp + 0x18c]
            //   c7436800000000       | mov                 dword ptr [esp + 0x58], edx
            //   c7436cffffffff       | mov                 edx, dword ptr [esp + 0x4a0]
            //   c74370ffffffff       | cmp                 edx, 0x80

        $sequence_4 = { c1ea10 885001 89f2 c1ea08 885002 }
            // n = 5, score = 200
            //   c1ea10               | ja                  0x123d
            //   885001               | mov                 esi, 0x6c696e3c
            //   89f2                 | mov                 ebx, dword ptr [edi + 8]
            //   c1ea08               | mov                 ebp, dword ptr [edi]
            //   885002               | cmp                 edx, ebx

        $sequence_5 = { 0f0b e8???????? 0f0b e8???????? 0f0b 0f0b }
            // n = 6, score = 200
            //   0f0b                 | mov                 dword ptr [ebp + 0x10], 1
            //   e8????????           |                     
            //   0f0b                 | inc                 dword ptr [esi + 0x3c]
            //   e8????????           |                     
            //   0f0b                 | mov                 dword ptr [ebp + 8], ebx
            //   0f0b                 | mov                 dword ptr [ebp + 0xc], ecx

        $sequence_6 = { e8???????? c7436000000000 c7838000000000000000 c7436800000000 c7436cffffffff c74370ffffffff }
            // n = 6, score = 200
            //   e8????????           |                     
            //   c7436000000000       | cmp                 eax, ebx
            //   c7838000000000000000     | ja    0x1071
            //   c7436800000000       | mov                 esi, dword ptr [esp + 0x9c]
            //   c7436cffffffff       | mov                 dword ptr [esp + 0x34], ebx
            //   c74370ffffffff       | lea                 ecx, [ebp + ecx + 8]

        $sequence_7 = { 7504 a80c 752f 83e0f3 }
            // n = 4, score = 200
            //   7504                 | mov                 dword ptr [esp + 0x20], ebx
            //   a80c                 | mov                 dword ptr [esp + 0x30], 0x46
            //   752f                 | dec                 eax
            //   83e0f3               | lea                 esi, [esp + 0x20]

        $sequence_8 = { 885001 89f2 c1ea08 885002 }
            // n = 4, score = 200
            //   885001               | je                  0x1f22
            //   89f2                 | and                 dword ptr [esi + 8], 0xfffffbff
            //   c1ea08               | test                eax, eax
            //   885002               | je                  0x49a8

        $sequence_9 = { c744243400000000 c744243800000000 c644243c00 c644243d00 }
            // n = 4, score = 200
            //   c744243400000000     | mov                 byte ptr [esp + 0x6c], cl
            //   c744243800000000     | lea                 esi, [esp + 0x20]
            //   c644243c00           | add                 esp, 0x34
            //   c644243d00           | ret                 

    condition:
        7 of them and filesize < 8396800
}