rule win_virut_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.virut."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.virut"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d8424d0000000 50 ffd6 83f8ff 0f8573030000 6800100000 }
            // n = 6, score = 200
            //   8d8424d0000000       | lea                 eax, [esp + 0xd0]
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   83f8ff               | cmp                 eax, -1
            //   0f8573030000         | jne                 0x379
            //   6800100000           | push                0x1000

        $sequence_1 = { 2bce 6a00 51 56 53 }
            // n = 5, score = 200
            //   2bce                 | sub                 ecx, esi
            //   6a00                 | push                0
            //   51                   | push                ecx
            //   56                   | push                esi
            //   53                   | push                ebx

        $sequence_2 = { 81e300f0ff0f 51 53 6a00 }
            // n = 4, score = 200
            //   81e300f0ff0f         | and                 ebx, 0xffff000
            //   51                   | push                ecx
            //   53                   | push                ebx
            //   6a00                 | push                0

        $sequence_3 = { b108 e8???????? 6894000000 5e 2be6 893424 }
            // n = 6, score = 200
            //   b108                 | mov                 cl, 8
            //   e8????????           |                     
            //   6894000000           | push                0x94
            //   5e                   | pop                 esi
            //   2be6                 | sub                 esp, esi
            //   893424               | mov                 dword ptr [esp], esi

        $sequence_4 = { 290c24 8b7224 59 03f3 8b521c }
            // n = 5, score = 200
            //   290c24               | sub                 dword ptr [esp], ecx
            //   8b7224               | mov                 esi, dword ptr [edx + 0x24]
            //   59                   | pop                 ecx
            //   03f3                 | add                 esi, ebx
            //   8b521c               | mov                 edx, dword ptr [edx + 0x1c]

        $sequence_5 = { 745b 50 54 6804010000 57 }
            // n = 5, score = 200
            //   745b                 | je                  0x5d
            //   50                   | push                eax
            //   54                   | push                esp
            //   6804010000           | push                0x104
            //   57                   | push                edi

        $sequence_6 = { cd2e 83f800 7c19 60 e8???????? 8b542430 5d }
            // n = 7, score = 200
            //   cd2e                 | int                 0x2e
            //   83f800               | cmp                 eax, 0
            //   7c19                 | jl                  0x1b
            //   60                   | pushal              
            //   e8????????           |                     
            //   8b542430             | mov                 edx, dword ptr [esp + 0x30]
            //   5d                   | pop                 ebp

        $sequence_7 = { 42 3ac3 75f6 8d8424d0010000 50 }
            // n = 5, score = 200
            //   42                   | inc                 edx
            //   3ac3                 | cmp                 al, bl
            //   75f6                 | jne                 0xfffffff8
            //   8d8424d0010000       | lea                 eax, [esp + 0x1d0]
            //   50                   | push                eax

        $sequence_8 = { 8b35???????? 53 8d442444 50 }
            // n = 4, score = 200
            //   8b35????????         |                     
            //   53                   | push                ebx
            //   8d442444             | lea                 eax, [esp + 0x44]
            //   50                   | push                eax

        $sequence_9 = { 3acb 7423 8bf8 8ac1 2c30 3c09 7719 }
            // n = 7, score = 200
            //   3acb                 | cmp                 cl, bl
            //   7423                 | je                  0x25
            //   8bf8                 | mov                 edi, eax
            //   8ac1                 | mov                 al, cl
            //   2c30                 | sub                 al, 0x30
            //   3c09                 | cmp                 al, 9
            //   7719                 | ja                  0x1b

        $sequence_10 = { ab 6a10 8d45ec 50 53 }
            // n = 5, score = 200
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   6a10                 | push                0x10
            //   8d45ec               | lea                 eax, [ebp - 0x14]
            //   50                   | push                eax
            //   53                   | push                ebx

        $sequence_11 = { 53 6a05 8bcc 50 8bd4 50 }
            // n = 6, score = 200
            //   53                   | push                ebx
            //   6a05                 | push                5
            //   8bcc                 | mov                 ecx, esp
            //   50                   | push                eax
            //   8bd4                 | mov                 edx, esp
            //   50                   | push                eax

        $sequence_12 = { 0f31 03c2 a3???????? ff15???????? a3???????? 8d8424e0030000 }
            // n = 6, score = 200
            //   0f31                 | rdtsc               
            //   03c2                 | add                 eax, edx
            //   a3????????           |                     
            //   ff15????????         |                     
            //   a3????????           |                     
            //   8d8424e0030000       | lea                 eax, [esp + 0x3e0]

        $sequence_13 = { 2e44 4c 4c 00ff 95 }
            // n = 5, score = 200
            //   2e44                 | inc                 esp
            //   4c                   | dec                 esp
            //   4c                   | dec                 esp
            //   00ff                 | add                 bh, bh
            //   95                   | xchg                eax, ebp

        $sequence_14 = { 56 8d442444 53 50 e8???????? 33c0 8d7c243c }
            // n = 7, score = 200
            //   56                   | push                esi
            //   8d442444             | lea                 eax, [esp + 0x44]
            //   53                   | push                ebx
            //   50                   | push                eax
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax
            //   8d7c243c             | lea                 edi, [esp + 0x3c]

        $sequence_15 = { 803f4d 0f85f9000000 807f015a 0f85ef000000 885c2420 885c2421 885c2422 }
            // n = 7, score = 200
            //   803f4d               | cmp                 byte ptr [edi], 0x4d
            //   0f85f9000000         | jne                 0xff
            //   807f015a             | cmp                 byte ptr [edi + 1], 0x5a
            //   0f85ef000000         | jne                 0xf5
            //   885c2420             | mov                 byte ptr [esp + 0x20], bl
            //   885c2421             | mov                 byte ptr [esp + 0x21], bl
            //   885c2422             | mov                 byte ptr [esp + 0x22], bl

    condition:
        7 of them and filesize < 98304
}