rule win_vsingle_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.vsingle."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.vsingle"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 66898568fdffff 8d8d6cfdffff 51 0fb79568fdffff }
            // n = 4, score = 700
            //   66898568fdffff       | mov                 word ptr [ebp - 0x298], ax
            //   8d8d6cfdffff         | lea                 ecx, [ebp - 0x294]
            //   51                   | push                ecx
            //   0fb79568fdffff       | movzx               edx, word ptr [ebp - 0x298]

        $sequence_1 = { 668955f8 b801000000 6bc800 8a540de8 }
            // n = 4, score = 700
            //   668955f8             | mov                 word ptr [ebp - 8], dx
            //   b801000000           | mov                 eax, 1
            //   6bc800               | imul                ecx, eax, 0
            //   8a540de8             | mov                 dl, byte ptr [ebp + ecx - 0x18]

        $sequence_2 = { 83c204 8955fc 8b45f8 0345fc 8b4d10 8908 8b55fc }
            // n = 7, score = 700
            //   83c204               | add                 edx, 4
            //   8955fc               | mov                 dword ptr [ebp - 4], edx
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   0345fc               | add                 eax, dword ptr [ebp - 4]
            //   8b4d10               | mov                 ecx, dword ptr [ebp + 0x10]
            //   8908                 | mov                 dword ptr [eax], ecx
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]

        $sequence_3 = { 668955f9 8855fb c785d4fbffff07020000 8d85d4fbffff }
            // n = 4, score = 700
            //   668955f9             | mov                 word ptr [ebp - 7], dx
            //   8855fb               | mov                 byte ptr [ebp - 5], dl
            //   c785d4fbffff07020000     | mov    dword ptr [ebp - 0x42c], 0x207
            //   8d85d4fbffff         | lea                 eax, [ebp - 0x42c]

        $sequence_4 = { 668955f8 c745f46c4e078e 8b450c 8945fc }
            // n = 4, score = 700
            //   668955f8             | mov                 word ptr [ebp - 8], dx
            //   c745f46c4e078e       | mov                 dword ptr [ebp - 0xc], 0x8e074e6c
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   8945fc               | mov                 dword ptr [ebp - 4], eax

        $sequence_5 = { 8a540de8 8815???????? b801000000 c1e000 8a4c05e8 880d???????? 8d55ea }
            // n = 7, score = 700
            //   8a540de8             | mov                 dl, byte ptr [ebp + ecx - 0x18]
            //   8815????????         |                     
            //   b801000000           | mov                 eax, 1
            //   c1e000               | shl                 eax, 0
            //   8a4c05e8             | mov                 cl, byte ptr [ebp + eax - 0x18]
            //   880d????????         |                     
            //   8d55ea               | lea                 edx, [ebp - 0x16]

        $sequence_6 = { 8a5415f8 88540df8 b801000000 d1e0 b901000000 c1e100 8a5405f8 }
            // n = 7, score = 700
            //   8a5415f8             | mov                 dl, byte ptr [ebp + edx - 8]
            //   88540df8             | mov                 byte ptr [ebp + ecx - 8], dl
            //   b801000000           | mov                 eax, 1
            //   d1e0                 | shl                 eax, 1
            //   b901000000           | mov                 ecx, 1
            //   c1e100               | shl                 ecx, 0
            //   8a5405f8             | mov                 dl, byte ptr [ebp + eax - 8]

        $sequence_7 = { 668955ee c745f000000000 b810000000 668945f8 c745f4f756bd64 eb20 }
            // n = 6, score = 700
            //   668955ee             | mov                 word ptr [ebp - 0x12], dx
            //   c745f000000000       | mov                 dword ptr [ebp - 0x10], 0
            //   b810000000           | mov                 eax, 0x10
            //   668945f8             | mov                 word ptr [ebp - 8], ax
            //   c745f4f756bd64       | mov                 dword ptr [ebp - 0xc], 0x64bd56f7
            //   eb20                 | jmp                 0x22

        $sequence_8 = { 81e90ccf1926 394dfc 59 7505 e9???????? 50 }
            // n = 6, score = 100
            //   81e90ccf1926         | sub                 ecx, 0x2619cf0c
            //   394dfc               | cmp                 dword ptr [ebp - 4], ecx
            //   59                   | pop                 ecx
            //   7505                 | jne                 7
            //   e9????????           |                     
            //   50                   | push                eax

        $sequence_9 = { 81f7e7c25008 81c7892b0bc9 81c748a095dd eb11 }
            // n = 4, score = 100
            //   81f7e7c25008         | xor                 edi, 0x850c2e7
            //   81c7892b0bc9         | add                 edi, 0xc90b2b89
            //   81c748a095dd         | add                 edi, 0xdd95a048
            //   eb11                 | jmp                 0x13

        $sequence_10 = { 51 b9a251215b 81c1ea838beb 81f149ac3b55 }
            // n = 4, score = 100
            //   51                   | push                ecx
            //   b9a251215b           | mov                 ecx, 0x5b2151a2
            //   81c1ea838beb         | add                 ecx, 0xeb8b83ea
            //   81f149ac3b55         | xor                 ecx, 0x553bac49

        $sequence_11 = { 51 b91604ec6b e9???????? 81f097f6a505 81f057a7f1cc }
            // n = 5, score = 100
            //   51                   | push                ecx
            //   b91604ec6b           | mov                 ecx, 0x6bec0416
            //   e9????????           |                     
            //   81f097f6a505         | xor                 eax, 0x5a5f697
            //   81f057a7f1cc         | xor                 eax, 0xccf1a757

        $sequence_12 = { 885da0 eb21 81eaf7fb4a93 81f21bea8dcb 81c25444399b }
            // n = 5, score = 100
            //   885da0               | mov                 byte ptr [ebp - 0x60], bl
            //   eb21                 | jmp                 0x23
            //   81eaf7fb4a93         | sub                 edx, 0x934afbf7
            //   81f21bea8dcb         | xor                 edx, 0xcb8dea1b
            //   81c25444399b         | add                 edx, 0x9b394454

        $sequence_13 = { 81f1367858fe 81f12158256c 894c2404 59 ff15???????? }
            // n = 5, score = 100
            //   81f1367858fe         | xor                 ecx, 0xfe587836
            //   81f12158256c         | xor                 ecx, 0x6c255821
            //   894c2404             | mov                 dword ptr [esp + 4], ecx
            //   59                   | pop                 ecx
            //   ff15????????         |                     

        $sequence_14 = { 50 b89da54c19 81c01ab7de15 81f05c64d929 81f0714ef44c }
            // n = 5, score = 100
            //   50                   | push                eax
            //   b89da54c19           | mov                 eax, 0x194ca59d
            //   81c01ab7de15         | add                 eax, 0x15deb71a
            //   81f05c64d929         | xor                 eax, 0x29d9645c
            //   81f0714ef44c         | xor                 eax, 0x4cf44e71

        $sequence_15 = { 81c3af0f8c7e e9???????? 81c3ea117171 81c36738f462 81c315173337 81c3beb17872 81eb4b94fb51 }
            // n = 7, score = 100
            //   81c3af0f8c7e         | add                 ebx, 0x7e8c0faf
            //   e9????????           |                     
            //   81c3ea117171         | add                 ebx, 0x717111ea
            //   81c36738f462         | add                 ebx, 0x62f43867
            //   81c315173337         | add                 ebx, 0x37331715
            //   81c3beb17872         | add                 ebx, 0x7278b1be
            //   81eb4b94fb51         | sub                 ebx, 0x51fb944b

    condition:
        7 of them and filesize < 940032
}