rule win_vyveva_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.vyveva."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.vyveva"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 58 50 5f 5f 50 5f 8b4c2430 }
            // n = 7, score = 100
            //   58                   | pop                 eax
            //   50                   | push                eax
            //   5f                   | pop                 edi
            //   5f                   | pop                 edi
            //   50                   | push                eax
            //   5f                   | pop                 edi
            //   8b4c2430             | mov                 ecx, dword ptr [esp + 0x30]

        $sequence_1 = { 7404 894424fc 83ec04 2bc1 58 75e2 8d4c2418 }
            // n = 7, score = 100
            //   7404                 | je                  6
            //   894424fc             | mov                 dword ptr [esp - 4], eax
            //   83ec04               | sub                 esp, 4
            //   2bc1                 | sub                 eax, ecx
            //   58                   | pop                 eax
            //   75e2                 | jne                 0xffffffe4
            //   8d4c2418             | lea                 ecx, [esp + 0x18]

        $sequence_2 = { 51 89442414 8bce e8???????? 8b942430020000 8d44240c 6a04 }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   89442414             | mov                 dword ptr [esp + 0x14], eax
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   8b942430020000       | mov                 edx, dword ptr [esp + 0x230]
            //   8d44240c             | lea                 eax, [esp + 0xc]
            //   6a04                 | push                4

        $sequence_3 = { ffb5ac000000 58 85c0 0f85f2010000 68???????? ff15???????? 50 }
            // n = 7, score = 100
            //   ffb5ac000000         | push                dword ptr [ebp + 0xac]
            //   58                   | pop                 eax
            //   85c0                 | test                eax, eax
            //   0f85f2010000         | jne                 0x1f8
            //   68????????           |                     
            //   ff15????????         |                     
            //   50                   | push                eax

        $sequence_4 = { 8b4c2410 6a00 51 6a03 6a00 }
            // n = 5, score = 100
            //   8b4c2410             | mov                 ecx, dword ptr [esp + 0x10]
            //   6a00                 | push                0
            //   51                   | push                ecx
            //   6a03                 | push                3
            //   6a00                 | push                0

        $sequence_5 = { 8d8c2468010000 50 51 6a41 e8???????? 83c404 ffd0 }
            // n = 7, score = 100
            //   8d8c2468010000       | lea                 ecx, [esp + 0x168]
            //   50                   | push                eax
            //   51                   | push                ecx
            //   6a41                 | push                0x41
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   ffd0                 | call                eax

        $sequence_6 = { 8d4c2418 c644243800 e8???????? 8d4c2424 57 51 8d4d14 }
            // n = 7, score = 100
            //   8d4c2418             | lea                 ecx, [esp + 0x18]
            //   c644243800           | mov                 byte ptr [esp + 0x38], 0
            //   e8????????           |                     
            //   8d4c2424             | lea                 ecx, [esp + 0x24]
            //   57                   | push                edi
            //   51                   | push                ecx
            //   8d4d14               | lea                 ecx, [ebp + 0x14]

        $sequence_7 = { 83ec04 33db 8d5c194c 83eb4c c74424fc0c000000 83ec04 }
            // n = 6, score = 100
            //   83ec04               | sub                 esp, 4
            //   33db                 | xor                 ebx, ebx
            //   8d5c194c             | lea                 ebx, [ecx + ebx + 0x4c]
            //   83eb4c               | sub                 ebx, 0x4c
            //   c74424fc0c000000     | mov                 dword ptr [esp - 4], 0xc
            //   83ec04               | sub                 esp, 4

        $sequence_8 = { 5b 53 59 59 53 51 5b }
            // n = 7, score = 100
            //   5b                   | pop                 ebx
            //   53                   | push                ebx
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   53                   | push                ebx
            //   51                   | push                ecx
            //   5b                   | pop                 ebx

        $sequence_9 = { 8bce e8???????? 8b942430020000 8d44240c 6a04 50 56 }
            // n = 7, score = 100
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   8b942430020000       | mov                 edx, dword ptr [esp + 0x230]
            //   8d44240c             | lea                 eax, [esp + 0xc]
            //   6a04                 | push                4
            //   50                   | push                eax
            //   56                   | push                esi

    condition:
        7 of them and filesize < 360448
}