rule win_wastedlocker_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.wastedlocker."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.wastedlocker"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c40c 56 8d85b0ebffff 53 }
            // n = 4, score = 1000
            //   83c40c               | add                 esp, 0xc
            //   56                   | push                esi
            //   8d85b0ebffff         | lea                 eax, [ebp - 0x1450]
            //   53                   | push                ebx

        $sequence_1 = { ff75f8 8bc7 2bc6 83c038 50 ff7508 }
            // n = 6, score = 1000
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   8bc7                 | mov                 eax, edi
            //   2bc6                 | sub                 eax, esi
            //   83c038               | add                 eax, 0x38
            //   50                   | push                eax
            //   ff7508               | push                dword ptr [ebp + 8]

        $sequence_2 = { 8d45fc 50 8975f8 ff15???????? 50 ff7508 ff15???????? }
            // n = 7, score = 1000
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax
            //   8975f8               | mov                 dword ptr [ebp - 8], esi
            //   ff15????????         |                     
            //   50                   | push                eax
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ff15????????         |                     

        $sequence_3 = { 6808000200 c745f400200000 895df0 ff15???????? }
            // n = 4, score = 1000
            //   6808000200           | push                0x20008
            //   c745f400200000       | mov                 dword ptr [ebp - 0xc], 0x2000
            //   895df0               | mov                 dword ptr [ebp - 0x10], ebx
            //   ff15????????         |                     

        $sequence_4 = { 58 eb0b 8d4d0c 51 50 53 }
            // n = 6, score = 1000
            //   58                   | pop                 eax
            //   eb0b                 | jmp                 0xd
            //   8d4d0c               | lea                 ecx, [ebp + 0xc]
            //   51                   | push                ecx
            //   50                   | push                eax
            //   53                   | push                ebx

        $sequence_5 = { ff742424 ff15???????? 8bf0 83feff 7428 ff742418 }
            // n = 6, score = 1000
            //   ff742424             | push                dword ptr [esp + 0x24]
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   83feff               | cmp                 esi, -1
            //   7428                 | je                  0x2a
            //   ff742418             | push                dword ptr [esp + 0x18]

        $sequence_6 = { 8bc3 e8???????? 85c0 7404 8365f000 6a00 8d45f4 }
            // n = 7, score = 1000
            //   8bc3                 | mov                 eax, ebx
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7404                 | je                  6
            //   8365f000             | and                 dword ptr [ebp - 0x10], 0
            //   6a00                 | push                0
            //   8d45f4               | lea                 eax, [ebp - 0xc]

        $sequence_7 = { 6a08 eb02 6a57 5e 5f 8bc6 5e }
            // n = 7, score = 1000
            //   6a08                 | push                8
            //   eb02                 | jmp                 4
            //   6a57                 | push                0x57
            //   5e                   | pop                 esi
            //   5f                   | pop                 edi
            //   8bc6                 | mov                 eax, esi
            //   5e                   | pop                 esi

        $sequence_8 = { 53 8bf8 ff15???????? eb08 ff15???????? 8bf8 }
            // n = 6, score = 1000
            //   53                   | push                ebx
            //   8bf8                 | mov                 edi, eax
            //   ff15????????         |                     
            //   eb08                 | jmp                 0xa
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax

        $sequence_9 = { ff750c 8b4518 ff7508 e8???????? 6800020000 8bf0 8d85f8fdffff }
            // n = 7, score = 1000
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   8b4518               | mov                 eax, dword ptr [ebp + 0x18]
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     
            //   6800020000           | push                0x200
            //   8bf0                 | mov                 esi, eax
            //   8d85f8fdffff         | lea                 eax, [ebp - 0x208]

    condition:
        7 of them and filesize < 147456
}