rule win_webc2_adspace_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.webc2_adspace."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.webc2_adspace"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d8580feffff 68???????? 50 ffd6 ff750c 894510 }
            // n = 6, score = 100
            //   8d8580feffff         | lea                 eax, [ebp - 0x180]
            //   68????????           |                     
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   894510               | mov                 dword ptr [ebp + 0x10], eax

        $sequence_1 = { ffd6 8bf8 c70424???????? ffd6 }
            // n = 4, score = 100
            //   ffd6                 | call                esi
            //   8bf8                 | mov                 edi, eax
            //   c70424????????       |                     
            //   ffd6                 | call                esi

        $sequence_2 = { 50 8d8580feffff 50 e8???????? 8b35???????? 8d8580feffff }
            // n = 6, score = 100
            //   50                   | push                eax
            //   8d8580feffff         | lea                 eax, [ebp - 0x180]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b35????????         |                     
            //   8d8580feffff         | lea                 eax, [ebp - 0x180]

        $sequence_3 = { 8d4dec e8???????? 8d4dec e8???????? 6a0a ff15???????? a1???????? }
            // n = 7, score = 100
            //   8d4dec               | lea                 ecx, [ebp - 0x14]
            //   e8????????           |                     
            //   8d4dec               | lea                 ecx, [ebp - 0x14]
            //   e8????????           |                     
            //   6a0a                 | push                0xa
            //   ff15????????         |                     
            //   a1????????           |                     

        $sequence_4 = { c3 56 8b742408 56 e8???????? 59 8b4c2410 }
            // n = 7, score = 100
            //   c3                   | ret                 
            //   56                   | push                esi
            //   8b742408             | mov                 esi, dword ptr [esp + 8]
            //   56                   | push                esi
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   8b4c2410             | mov                 ecx, dword ptr [esp + 0x10]

        $sequence_5 = { 0f84f8010000 80a4241c01000000 6a3f 59 33c0 }
            // n = 5, score = 100
            //   0f84f8010000         | je                  0x1fe
            //   80a4241c01000000     | and                 byte ptr [esp + 0x11c], 0
            //   6a3f                 | push                0x3f
            //   59                   | pop                 ecx
            //   33c0                 | xor                 eax, eax

        $sequence_6 = { 7469 6a00 57 56 }
            // n = 4, score = 100
            //   7469                 | je                  0x6b
            //   6a00                 | push                0
            //   57                   | push                edi
            //   56                   | push                esi

        $sequence_7 = { 50 e8???????? 83c40c 8bf8 8d45fc 50 }
            // n = 6, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8bf8                 | mov                 edi, eax
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax

        $sequence_8 = { 59 33c0 85ff 59 }
            // n = 4, score = 100
            //   59                   | pop                 ecx
            //   33c0                 | xor                 eax, eax
            //   85ff                 | test                edi, edi
            //   59                   | pop                 ecx

        $sequence_9 = { a1???????? 40 50 57 56 }
            // n = 5, score = 100
            //   a1????????           |                     
            //   40                   | inc                 eax
            //   50                   | push                eax
            //   57                   | push                edi
            //   56                   | push                esi

    condition:
        7 of them and filesize < 49152
}