rule win_webc2_ausov_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.webc2_ausov."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.webc2_ausov"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c408 50 ff15???????? 8945f8 0f8407000000 }
            // n = 5, score = 100
            //   83c408               | add                 esp, 8
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   0f8407000000         | je                  0xd

        $sequence_1 = { 8dbdfcfbffff 83c9ff 33c0 f2ae }
            // n = 4, score = 100
            //   8dbdfcfbffff         | lea                 edi, [ebp - 0x404]
            //   83c9ff               | or                  ecx, 0xffffffff
            //   33c0                 | xor                 eax, eax
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]

        $sequence_2 = { 83c408 50 8b85f8fbffff 50 e8???????? }
            // n = 5, score = 100
            //   83c408               | add                 esp, 8
            //   50                   | push                eax
            //   8b85f8fbffff         | mov                 eax, dword ptr [ebp - 0x408]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_3 = { e8???????? 83c40c 85c0 754e 0f8407000000 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   85c0                 | test                eax, eax
            //   754e                 | jne                 0x50
            //   0f8407000000         | je                  0xd

        $sequence_4 = { 50 68???????? ff15???????? 8985c4fdffff }
            // n = 4, score = 100
            //   50                   | push                eax
            //   68????????           |                     
            //   ff15????????         |                     
            //   8985c4fdffff         | mov                 dword ptr [ebp - 0x23c], eax

        $sequence_5 = { e9???????? 8d8db0fbffff 51 8d9500feffff 52 }
            // n = 5, score = 100
            //   e9????????           |                     
            //   8d8db0fbffff         | lea                 ecx, [ebp - 0x450]
            //   51                   | push                ecx
            //   8d9500feffff         | lea                 edx, [ebp - 0x200]
            //   52                   | push                edx

        $sequence_6 = { 83ad34faffff01 83bd34faffff00 7429 83ad34faffff01 83bd34faffff00 7448 e9???????? }
            // n = 7, score = 100
            //   83ad34faffff01       | sub                 dword ptr [ebp - 0x5cc], 1
            //   83bd34faffff00       | cmp                 dword ptr [ebp - 0x5cc], 0
            //   7429                 | je                  0x2b
            //   83ad34faffff01       | sub                 dword ptr [ebp - 0x5cc], 1
            //   83bd34faffff00       | cmp                 dword ptr [ebp - 0x5cc], 0
            //   7448                 | je                  0x4a
            //   e9????????           |                     

        $sequence_7 = { 7429 83ad34faffff01 83bd34faffff00 7448 }
            // n = 4, score = 100
            //   7429                 | je                  0x2b
            //   83ad34faffff01       | sub                 dword ptr [ebp - 0x5cc], 1
            //   83bd34faffff00       | cmp                 dword ptr [ebp - 0x5cc], 0
            //   7448                 | je                  0x4a

        $sequence_8 = { 8b954cfaffff 3a4a01 7523 838548faffff02 83854cfaffff02 }
            // n = 5, score = 100
            //   8b954cfaffff         | mov                 edx, dword ptr [ebp - 0x5b4]
            //   3a4a01               | cmp                 cl, byte ptr [edx + 1]
            //   7523                 | jne                 0x25
            //   838548faffff02       | add                 dword ptr [ebp - 0x5b8], 2
            //   83854cfaffff02       | add                 dword ptr [ebp - 0x5b4], 2

        $sequence_9 = { b90d000000 33c0 8dbdc9fdffff f3ab }
            // n = 4, score = 100
            //   b90d000000           | mov                 ecx, 0xd
            //   33c0                 | xor                 eax, eax
            //   8dbdc9fdffff         | lea                 edi, [ebp - 0x237]
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax

    condition:
        7 of them and filesize < 40960
}