rule win_webc2_yahoo_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.webc2_yahoo."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.webc2_yahoo"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff75e4 ffd7 85c0 7453 837dec00 }
            // n = 5, score = 100
            //   ff75e4               | push                dword ptr [ebp - 0x1c]
            //   ffd7                 | call                edi
            //   85c0                 | test                eax, eax
            //   7453                 | je                  0x55
            //   837dec00             | cmp                 dword ptr [ebp - 0x14], 0

        $sequence_1 = { 8d8507ffffff be???????? 50 56 e8???????? 6a00 }
            // n = 6, score = 100
            //   8d8507ffffff         | lea                 eax, [ebp - 0xf9]
            //   be????????           |                     
            //   50                   | push                eax
            //   56                   | push                esi
            //   e8????????           |                     
            //   6a00                 | push                0

        $sequence_2 = { 8365c800 6a09 59 33c0 8d7dcc 53 f3ab }
            // n = 7, score = 100
            //   8365c800             | and                 dword ptr [ebp - 0x38], 0
            //   6a09                 | push                9
            //   59                   | pop                 ecx
            //   33c0                 | xor                 eax, eax
            //   8d7dcc               | lea                 edi, [ebp - 0x34]
            //   53                   | push                ebx
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax

        $sequence_3 = { 57 ff75fc 0345f4 50 e8???????? 56 e8???????? }
            // n = 7, score = 100
            //   57                   | push                edi
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   0345f4               | add                 eax, dword ptr [ebp - 0xc]
            //   50                   | push                eax
            //   e8????????           |                     
            //   56                   | push                esi
            //   e8????????           |                     

        $sequence_4 = { eb9f b8???????? c3 55 8bec }
            // n = 5, score = 100
            //   eb9f                 | jmp                 0xffffffa1
            //   b8????????           |                     
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp

        $sequence_5 = { 59 8bc6 5e c20400 33c0 c701???????? 89819c841e00 }
            // n = 7, score = 100
            //   59                   | pop                 ecx
            //   8bc6                 | mov                 eax, esi
            //   5e                   | pop                 esi
            //   c20400               | ret                 4
            //   33c0                 | xor                 eax, eax
            //   c701????????         |                     
            //   89819c841e00         | mov                 dword ptr [ecx + 0x1e849c], eax

        $sequence_6 = { 8816 8a11 8817 8a10 33db }
            // n = 5, score = 100
            //   8816                 | mov                 byte ptr [esi], dl
            //   8a11                 | mov                 dl, byte ptr [ecx]
            //   8817                 | mov                 byte ptr [edi], dl
            //   8a10                 | mov                 dl, byte ptr [eax]
            //   33db                 | xor                 ebx, ebx

        $sequence_7 = { 50 ff15???????? 6a64 e8???????? 8d85fcd7ffff }
            // n = 5, score = 100
            //   50                   | push                eax
            //   ff15????????         |                     
            //   6a64                 | push                0x64
            //   e8????????           |                     
            //   8d85fcd7ffff         | lea                 eax, [ebp - 0x2804]

        $sequence_8 = { c686????????40 46 33c9 53 c686????????23 }
            // n = 5, score = 100
            //   c686????????40       |                     
            //   46                   | inc                 esi
            //   33c9                 | xor                 ecx, ecx
            //   53                   | push                ebx
            //   c686????????23       |                     

        $sequence_9 = { 8d85fcd7ffff 57 50 ebb4 6a64 5b }
            // n = 6, score = 100
            //   8d85fcd7ffff         | lea                 eax, [ebp - 0x2804]
            //   57                   | push                edi
            //   50                   | push                eax
            //   ebb4                 | jmp                 0xffffffb6
            //   6a64                 | push                0x64
            //   5b                   | pop                 ebx

    condition:
        7 of them and filesize < 8060928
}