rule win_webmonitor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.webmonitor."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.webmonitor"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 72ff 800c0043 6c ff8010004368 ff1e 0a01 800c004a }
            // n = 7, score = 200
            //   72ff                 | jb                  1
            //   800c0043             | or                  byte ptr [eax + eax], 0x43
            //   6c                   | insb                byte ptr es:[edi], dx
            //   ff8010004368         | inc                 dword ptr [eax + 0x68430010]
            //   ff1e                 | lcall               [esi]
            //   0a01                 | or                  al, byte ptr [ecx]
            //   800c004a             | or                  byte ptr [eax + eax], 0x4a

        $sequence_1 = { 43 ec fe04ec fe05???????? 000d???????? 04c8 }
            // n = 6, score = 200
            //   43                   | inc                 ebx
            //   ec                   | in                  al, dx
            //   fe04ec               | inc                 byte ptr [esp + ebp*8]
            //   fe05????????         |                     
            //   000d????????         |                     
            //   04c8                 | add                 al, 0xc8

        $sequence_2 = { a4 44 43 00dc 7442 000477 }
            // n = 6, score = 200
            //   a4                   | movsb               byte ptr es:[edi], byte ptr [esi]
            //   44                   | inc                 esp
            //   43                   | inc                 ebx
            //   00dc                 | add                 ah, bl
            //   7442                 | je                  0x44
            //   000477               | add                 byte ptr [edi + esi*2], al

        $sequence_3 = { 41 0084e84100a872 42 00a06a4200f8 b642 }
            // n = 5, score = 200
            //   41                   | inc                 ecx
            //   0084e84100a872       | add                 byte ptr [eax + ebp*8 + 0x72a80041], al
            //   42                   | inc                 edx
            //   00a06a4200f8         | add                 byte ptr [eax - 0x7ffbd96], ah
            //   b642                 | mov                 dh, 0x42

        $sequence_4 = { 3a58ff 2503fd006c ff1e e00e 000e }
            // n = 5, score = 200
            //   3a58ff               | cmp                 bl, byte ptr [eax - 1]
            //   2503fd006c           | and                 eax, 0x6c00fd03
            //   ff1e                 | lcall               [esi]
            //   e00e                 | loopne              0x10
            //   000e                 | add                 byte ptr [esi], cl

        $sequence_5 = { ff05???????? 000d???????? 04b8 fe04f4 fd }
            // n = 5, score = 200
            //   ff05????????         |                     
            //   000d????????         |                     
            //   04b8                 | add                 al, 0xb8
            //   fe04f4               | inc                 byte ptr [esp + esi*8]
            //   fd                   | std                 

        $sequence_6 = { 41 00baa4f34100 b9???????? ffe1 ba???????? }
            // n = 5, score = 200
            //   41                   | inc                 ecx
            //   00baa4f34100         | add                 byte ptr [edx + 0x41f3a4], bh
            //   b9????????           |                     
            //   ffe1                 | jmp                 ecx
            //   ba????????           |                     

        $sequence_7 = { 0512002413 000d???????? 04f4 fd 0468 ff05???????? }
            // n = 6, score = 200
            //   0512002413           | add                 eax, 0x13240012
            //   000d????????         |                     
            //   04f4                 | add                 al, 0xf4
            //   fd                   | std                 
            //   0468                 | add                 al, 0x68
            //   ff05????????         |                     

        $sequence_8 = { 00e8 dd7000 008bf98b5d1c 8d4de4 }
            // n = 4, score = 100
            //   00e8                 | add                 al, ch
            //   dd7000               | fnsave              dword ptr [eax]
            //   008bf98b5d1c         | add                 byte ptr [ebx + 0x1c5d8bf9], cl
            //   8d4de4               | lea                 ecx, [ebp - 0x1c]

        $sequence_9 = { 00d1 6848007269 48 00856948008b }
            // n = 4, score = 100
            //   00d1                 | add                 cl, dl
            //   6848007269           | push                0x69720048
            //   48                   | dec                 eax
            //   00856948008b         | add                 byte ptr [ebp - 0x74ffb797], al

        $sequence_10 = { 0108 eb5a 8b4508 83ceff }
            // n = 4, score = 100
            //   0108                 | add                 dword ptr [eax], ecx
            //   eb5a                 | jmp                 0x5c
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   83ceff               | or                  esi, 0xffffffff

        $sequence_11 = { 0108 8b442410 891e 894604 }
            // n = 4, score = 100
            //   0108                 | add                 dword ptr [eax], ecx
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]
            //   891e                 | mov                 dword ptr [esi], ebx
            //   894604               | mov                 dword ptr [esi + 4], eax

        $sequence_12 = { 00d1 6848004069 48 00d1 }
            // n = 4, score = 100
            //   00d1                 | add                 cl, dl
            //   6848004069           | push                0x69400048
            //   48                   | dec                 eax
            //   00d1                 | add                 cl, dl

        $sequence_13 = { 000f b681 fc b84500ff24 }
            // n = 4, score = 100
            //   000f                 | add                 byte ptr [edi], cl
            //   b681                 | mov                 dh, 0x81
            //   fc                   | cld                 
            //   b84500ff24           | mov                 eax, 0x24ff0045

        $sequence_14 = { 00e8 f61c00 008bd9895df0 8b451c }
            // n = 4, score = 100
            //   00e8                 | add                 al, ch
            //   f61c00               | neg                 byte ptr [eax + eax]
            //   008bd9895df0         | add                 byte ptr [ebx - 0xfa27627], cl
            //   8b451c               | mov                 eax, dword ptr [ebp + 0x1c]

        $sequence_15 = { 00856948008b ff558b ec 83ec0c }
            // n = 4, score = 100
            //   00856948008b         | add                 byte ptr [ebp - 0x74ffb797], al
            //   ff558b               | call                dword ptr [ebp - 0x75]
            //   ec                   | in                  al, dx
            //   83ec0c               | sub                 esp, 0xc

    condition:
        7 of them and filesize < 1867776
}