rule win_whispergate_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.whispergate."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.whispergate"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 89442404 8b4208 890424 e8???????? 85c0 7426 8b4b04 }
            // n = 7, score = 300
            //   89442404             | mov                 dword ptr [esp + 4], eax
            //   8b4208               | mov                 eax, dword ptr [edx + 8]
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7426                 | je                  0x28
            //   8b4b04               | mov                 ecx, dword ptr [ebx + 4]

        $sequence_1 = { 85d2 c7049100000000 75f2 31c0 }
            // n = 4, score = 300
            //   85d2                 | test                edx, edx
            //   c7049100000000       | mov                 dword ptr [ecx + edx*4], 0
            //   75f2                 | jne                 0xfffffff4
            //   31c0                 | xor                 eax, eax

        $sequence_2 = { 83c101 84c0 8842ff 75f0 8b4508 890424 8b75d0 }
            // n = 7, score = 300
            //   83c101               | add                 ecx, 1
            //   84c0                 | test                al, al
            //   8842ff               | mov                 byte ptr [edx - 1], al
            //   75f0                 | jne                 0xfffffff2
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   890424               | mov                 dword ptr [esp], eax
            //   8b75d0               | mov                 esi, dword ptr [ebp - 0x30]

        $sequence_3 = { e8???????? e9???????? c745c000000000 e9???????? 8903 8b5db8 85db }
            // n = 7, score = 300
            //   e8????????           |                     
            //   e9????????           |                     
            //   c745c000000000       | mov                 dword ptr [ebp - 0x40], 0
            //   e9????????           |                     
            //   8903                 | mov                 dword ptr [ebx], eax
            //   8b5db8               | mov                 ebx, dword ptr [ebp - 0x48]
            //   85db                 | test                ebx, ebx

        $sequence_4 = { 83c41c c3 c705????????ffffffff dbe3 }
            // n = 4, score = 300
            //   83c41c               | add                 esp, 0x1c
            //   c3                   | ret                 
            //   c705????????ffffffff     |     
            //   dbe3                 | fninit              

        $sequence_5 = { 784f 891c24 e8???????? 85f6 }
            // n = 4, score = 300
            //   784f                 | js                  0x51
            //   891c24               | mov                 dword ptr [esp], ebx
            //   e8????????           |                     
            //   85f6                 | test                esi, esi

        $sequence_6 = { c7042400000000 e8???????? 8d5001 89542404 }
            // n = 4, score = 300
            //   c7042400000000       | mov                 dword ptr [esp], 0
            //   e8????????           |                     
            //   8d5001               | lea                 edx, [eax + 1]
            //   89542404             | mov                 dword ptr [esp + 4], edx

        $sequence_7 = { 83ec0c 85c0 0f84a8000000 8b442438 }
            // n = 4, score = 300
            //   83ec0c               | sub                 esp, 0xc
            //   85c0                 | test                eax, eax
            //   0f84a8000000         | je                  0xae
            //   8b442438             | mov                 eax, dword ptr [esp + 0x38]

        $sequence_8 = { c1e004 e8???????? 29c4 c745e400000000 c745d400000000 }
            // n = 5, score = 300
            //   c1e004               | shl                 eax, 4
            //   e8????????           |                     
            //   29c4                 | sub                 esp, eax
            //   c745e400000000       | mov                 dword ptr [ebp - 0x1c], 0
            //   c745d400000000       | mov                 dword ptr [ebp - 0x2c], 0

        $sequence_9 = { 89de 8d44240c 89c7 8945c8 0fb603 3c7f 7428 }
            // n = 7, score = 300
            //   89de                 | mov                 esi, ebx
            //   8d44240c             | lea                 eax, [esp + 0xc]
            //   89c7                 | mov                 edi, eax
            //   8945c8               | mov                 dword ptr [ebp - 0x38], eax
            //   0fb603               | movzx               eax, byte ptr [ebx]
            //   3c7f                 | cmp                 al, 0x7f
            //   7428                 | je                  0x2a

    condition:
        7 of them and filesize < 114688
}