rule win_whitebird_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.whitebird."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.whitebird"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { eb09 80f92f 0f95c1 80c13f }
            // n = 4, score = 400
            //   eb09                 | jmp                 0xb
            //   80f92f               | cmp                 cl, 0x2f
            //   0f95c1               | setne               cl
            //   80c13f               | add                 cl, 0x3f

        $sequence_1 = { 33c0 e9???????? 4883c9ff 33c0 488dbc2470020000 66f2af }
            // n = 6, score = 200
            //   33c0                 | xor                 ecx, ecx
            //   e9????????           |                     
            //   4883c9ff             | cmp                 eax, ecx
            //   33c0                 | dec                 eax
            //   488dbc2470020000     | lea                 ecx, [0x4f4e]
            //   66f2af               | test                eax, eax

        $sequence_2 = { 8bcb e8???????? 8bcb e8???????? 85c0 7426 }
            // n = 6, score = 200
            //   8bcb                 | mov                 ecx, ebx
            //   e8????????           |                     
            //   8bcb                 | mov                 ecx, ebx
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7426                 | je                  0x28

        $sequence_3 = { 458d4102 e8???????? e9???????? e8???????? cc }
            // n = 5, score = 200
            //   458d4102             | je                  0x77
            //   e8????????           |                     
            //   e9????????           |                     
            //   e8????????           |                     
            //   cc                   | dec                 eax

        $sequence_4 = { d1f8 83f801 0f82e7010000 33c0 884df4 }
            // n = 5, score = 200
            //   d1f8                 | sar                 eax, 1
            //   83f801               | cmp                 eax, 1
            //   0f82e7010000         | jb                  0x1ed
            //   33c0                 | xor                 eax, eax
            //   884df4               | mov                 byte ptr [ebp - 0xc], cl

        $sequence_5 = { 8d45c0 50 ffb598fcffff c78594fcffff01000000 899d90fcffff ffd6 85c0 }
            // n = 7, score = 200
            //   8d45c0               | lea                 eax, [ebp - 0x40]
            //   50                   | push                eax
            //   ffb598fcffff         | push                dword ptr [ebp - 0x368]
            //   c78594fcffff01000000     | mov    dword ptr [ebp - 0x36c], 1
            //   899d90fcffff         | mov                 dword ptr [ebp - 0x370], ebx
            //   ffd6                 | call                esi
            //   85c0                 | test                eax, eax

        $sequence_6 = { 83fa20 75c6 41803841 7cc0 4180385a 7fba }
            // n = 6, score = 200
            //   83fa20               | or                  ecx, 0xffffffff
            //   75c6                 | xor                 eax, eax
            //   41803841             | dec                 eax
            //   7cc0                 | lea                 edi, [esp + 0x270]
            //   4180385a             | repne scasd         eax, dword ptr es:[edi]
            //   7fba                 | inc                 ebp

        $sequence_7 = { 7e34 eb05 b9409c0000 8bc3 2bc6 3bc1 7e02 }
            // n = 7, score = 200
            //   7e34                 | jle                 0x36
            //   eb05                 | jmp                 7
            //   b9409c0000           | mov                 ecx, 0x9c40
            //   8bc3                 | mov                 eax, ebx
            //   2bc6                 | sub                 eax, esi
            //   3bc1                 | cmp                 eax, ecx
            //   7e02                 | jle                 4

        $sequence_8 = { e8???????? 488d0d4e4f0000 ff15???????? 85c0 7473 488d0d3d4d0000 }
            // n = 6, score = 200
            //   e8????????           |                     
            //   488d0d4e4f0000       | dec                 eax
            //   ff15????????         |                     
            //   85c0                 | lea                 edx, [esp + 0x20]
            //   7473                 | dec                 eax
            //   488d0d3d4d0000       | mov                 ecx, ebp

        $sequence_9 = { 53 53 6a0b 68???????? }
            // n = 4, score = 200
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   6a0b                 | push                0xb
            //   68????????           |                     

        $sequence_10 = { 48f7d1 6689844c70020000 488d542420 488bcd ff15???????? 33c9 3bc1 }
            // n = 7, score = 200
            //   48f7d1               | xor                 edx, edx
            //   6689844c70020000     | inc                 ecx
            //   488d542420           | mov                 eax, 0x3fe
            //   488bcd               | dec                 eax
            //   ff15????????         |                     
            //   33c9                 | not                 ecx
            //   3bc1                 | mov                 word ptr [esp + ecx*2 + 0x270], ax

        $sequence_11 = { 488bd9 33c0 488d4c2432 33d2 41b8fe030000 }
            // n = 5, score = 200
            //   488bd9               | dec                 eax
            //   33c0                 | mov                 ebx, ecx
            //   488d4c2432           | xor                 eax, eax
            //   33d2                 | dec                 eax
            //   41b8fe030000         | lea                 ecx, [esp + 0x32]

        $sequence_12 = { 8ac1 b307 f6eb 30040e }
            // n = 4, score = 200
            //   8ac1                 | mov                 al, cl
            //   b307                 | mov                 bl, 7
            //   f6eb                 | imul                bl
            //   30040e               | xor                 byte ptr [esi + ecx], al

        $sequence_13 = { ff15???????? 48832300 4883c308 4883ef01 }
            // n = 4, score = 200
            //   ff15????????         |                     
            //   48832300             | lea                 ecx, [0x4d3d]
            //   4883c308             | xor                 eax, eax
            //   4883ef01             | dec                 eax

        $sequence_14 = { 888c05e8fdffff 40 33f6 85c9 761e 8dbc05e8fdffff 81feff000000 }
            // n = 7, score = 200
            //   888c05e8fdffff       | mov                 byte ptr [ebp + eax - 0x218], cl
            //   40                   | inc                 eax
            //   33f6                 | xor                 esi, esi
            //   85c9                 | test                ecx, ecx
            //   761e                 | jbe                 0x20
            //   8dbc05e8fdffff       | lea                 edi, [ebp + eax - 0x218]
            //   81feff000000         | cmp                 esi, 0xff

    condition:
        7 of them and filesize < 139264
}