rule win_whiteblackcrypt_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.whiteblackcrypt."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.whiteblackcrypt"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 790d b910270000 ff15???????? ebea e8???????? b805000030 31c9 }
            // n = 7, score = 100
            //   790d                 | jle                 0x10d
            //   b910270000           | lea                 eax, [eax - 2]
            //   ff15????????         |                     
            //   ebea                 | cmp                 eax, 1
            //   e8????????           |                     
            //   b805000030           | jbe                 0x18f
            //   31c9                 | inc                 eax

        $sequence_1 = { 4989e8 e8???????? 80be4402000000 4989c1 }
            // n = 4, score = 100
            //   4989e8               | dec                 eax
            //   e8????????           |                     
            //   80be4402000000       | mov                 esi, ecx
            //   4989c1               | dec                 eax

        $sequence_2 = { 418a530b 4188530f 418a5307 41884307 4188530b 0f8490000000 }
            // n = 6, score = 100
            //   418a530b             | mov                 ecx, ebx
            //   4188530f             | dec                 eax
            //   418a5307             | not                 ebx
            //   41884307             | dec                 eax
            //   4188530b             | not                 ecx
            //   0f8490000000         | add                 ecx, ebx

        $sequence_3 = { 45887801 e8???????? 4131c6 4531ca 4531ee 410fb6ca }
            // n = 6, score = 100
            //   45887801             | lea                 eax, [0x40c9]
            //   e8????????           |                     
            //   4131c6               | dec                 eax
            //   4531ca               | mov                 dword ptr [esp + 0x50], ebx
            //   4531ee               | mov                 ecx, 0x40000
            //   410fb6ca             | dec                 eax

        $sequence_4 = { e8???????? 4889c7 4989d9 41b800000002 }
            // n = 4, score = 100
            //   e8????????           |                     
            //   4889c7               | cmp                 ebp, ebx
            //   4989d9               | jbe                 0xa8d
            //   41b800000002         | xor                 eax, eax

        $sequence_5 = { c744242c413a5c00 89c5 f20f2acb 488b05???????? }
            // n = 4, score = 100
            //   c744242c413a5c00     | dec                 ebp
            //   89c5                 | cmp                 esp, eax
            //   f20f2acb             | dec                 ecx
            //   488b05????????       |                     

        $sequence_6 = { 83e820 8801 48ffc1 ebe8 c3 }
            // n = 5, score = 100
            //   83e820               | xor                 eax, ebp
            //   8801                 | movzx               ecx, cl
            //   48ffc1               | inc                 ecx
            //   ebe8                 | mov                 byte ptr [eax], al
            //   c3                   | inc                 esp

        $sequence_7 = { 4188530f 418a5307 41884307 4188530b 0f8490000000 }
            // n = 5, score = 100
            //   4188530f             | mov                 al, byte ptr [ebx + 2]
            //   418a5307             | mov                 byte ptr [esp + 0x3c], al
            //   41884307             | mov                 byte ptr [esp + 0x3c], al
            //   4188530b             | movzx               ecx, al
            //   0f8490000000         | mov                 byte ptr [esp + 0x3d], al

        $sequence_8 = { 488d1da9890000 488d35a2890000 4839de 74df 488b03 4885c0 }
            // n = 6, score = 100
            //   488d1da9890000       | lea                 eax, [ebx + 0x41]
            //   488d35a2890000       | dec                 eax
            //   4839de               | mov                 ecx, esi
            //   74df                 | mov                 byte ptr [esp + 0x2c], al
            //   488b03               | test                ecx, ecx
            //   4885c0               | setne               dl

        $sequence_9 = { 410f94c2 4409d0 4109cb 753a 84c0 }
            // n = 5, score = 100
            //   410f94c2             | je                  0x768
            //   4409d0               | ja                  0x725
            //   4109cb               | cmp                 edx, 1
            //   753a                 | cmp                 edx, 0xf
            //   84c0                 | je                  0x779

    condition:
        7 of them and filesize < 99328
}