rule win_winsloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.winsloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.winsloader"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 52 e8???????? 68???????? 8d743e06 e8???????? }
            // n = 5, score = 200
            //   52                   | push                edx
            //   e8????????           |                     
            //   68????????           |                     
            //   8d743e06             | lea                 esi, [esi + edi + 6]
            //   e8????????           |                     

        $sequence_1 = { 83c40c 6800040000 8d8dfcf7ffff 51 }
            // n = 4, score = 200
            //   83c40c               | add                 esp, 0xc
            //   6800040000           | push                0x400
            //   8d8dfcf7ffff         | lea                 ecx, [ebp - 0x804]
            //   51                   | push                ecx

        $sequence_2 = { e8???????? 66898435fcfbffff b8???????? 83c410 8d4801 8da42400000000 }
            // n = 6, score = 200
            //   e8????????           |                     
            //   66898435fcfbffff     | mov                 word ptr [ebp + esi - 0x404], ax
            //   b8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   8d4801               | lea                 ecx, [eax + 1]
            //   8da42400000000       | lea                 esp, [esp]

        $sequence_3 = { 8d95fcfbffff 52 0590120000 b920010000 }
            // n = 4, score = 200
            //   8d95fcfbffff         | lea                 edx, [ebp - 0x404]
            //   52                   | push                edx
            //   0590120000           | add                 eax, 0x1290
            //   b920010000           | mov                 ecx, 0x120

        $sequence_4 = { 84d2 75f9 2bc7 8bf8 b8???????? 8d5001 }
            // n = 6, score = 200
            //   84d2                 | test                dl, dl
            //   75f9                 | jne                 0xfffffffb
            //   2bc7                 | sub                 eax, edi
            //   8bf8                 | mov                 edi, eax
            //   b8????????           |                     
            //   8d5001               | lea                 edx, [eax + 1]

        $sequence_5 = { 2bc1 0fb7c0 57 8bf8 }
            // n = 4, score = 200
            //   2bc1                 | sub                 eax, ecx
            //   0fb7c0               | movzx               eax, ax
            //   57                   | push                edi
            //   8bf8                 | mov                 edi, eax

        $sequence_6 = { 57 8d45dc 50 8d4e10 51 }
            // n = 5, score = 200
            //   57                   | push                edi
            //   8d45dc               | lea                 eax, [ebp - 0x24]
            //   50                   | push                eax
            //   8d4e10               | lea                 ecx, [esi + 0x10]
            //   51                   | push                ecx

        $sequence_7 = { b8???????? 8d7801 8a10 40 84d2 }
            // n = 5, score = 200
            //   b8????????           |                     
            //   8d7801               | lea                 edi, [eax + 1]
            //   8a10                 | mov                 dl, byte ptr [eax]
            //   40                   | inc                 eax
            //   84d2                 | test                dl, dl

        $sequence_8 = { 75f9 2bc6 0fb6f0 8d5601 52 88841dfefbffff }
            // n = 6, score = 200
            //   75f9                 | jne                 0xfffffffb
            //   2bc6                 | sub                 eax, esi
            //   0fb6f0               | movzx               esi, al
            //   8d5601               | lea                 edx, [esi + 1]
            //   52                   | push                edx
            //   88841dfefbffff       | mov                 byte ptr [ebp + ebx - 0x402], al

        $sequence_9 = { 8d0485f83a0110 50 8d85c0f8ffff 03c7 50 e8???????? 8b85bcf8ffff }
            // n = 7, score = 100
            //   8d0485f83a0110       | lea                 eax, [eax*4 + 0x10013af8]
            //   50                   | push                eax
            //   8d85c0f8ffff         | lea                 eax, [ebp - 0x740]
            //   03c7                 | add                 eax, edi
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b85bcf8ffff         | mov                 eax, dword ptr [ebp - 0x744]

        $sequence_10 = { 83c40c 0fb795f0f3ffff 0395f8f3ffff 8995f8f3ffff }
            // n = 4, score = 100
            //   83c40c               | add                 esp, 0xc
            //   0fb795f0f3ffff       | movzx               edx, word ptr [ebp - 0xc10]
            //   0395f8f3ffff         | add                 edx, dword ptr [ebp - 0xc08]
            //   8995f8f3ffff         | mov                 dword ptr [ebp - 0xc08], edx

        $sequence_11 = { 8b74241c 8bcf 2bf7 8bd3 8a040e 8d4901 8841ff }
            // n = 7, score = 100
            //   8b74241c             | mov                 esi, dword ptr [esp + 0x1c]
            //   8bcf                 | mov                 ecx, edi
            //   2bf7                 | sub                 esi, edi
            //   8bd3                 | mov                 edx, ebx
            //   8a040e               | mov                 al, byte ptr [esi + ecx]
            //   8d4901               | lea                 ecx, [ecx + 1]
            //   8841ff               | mov                 byte ptr [ecx - 1], al

        $sequence_12 = { e9???????? c745e0547c0110 eba2 894ddc c745e0547c0110 e9???????? c745dc03000000 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   c745e0547c0110       | mov                 dword ptr [ebp - 0x20], 0x10017c54
            //   eba2                 | jmp                 0xffffffa4
            //   894ddc               | mov                 dword ptr [ebp - 0x24], ecx
            //   c745e0547c0110       | mov                 dword ptr [ebp - 0x20], 0x10017c54
            //   e9????????           |                     
            //   c745dc03000000       | mov                 dword ptr [ebp - 0x24], 3

        $sequence_13 = { be???????? f3a5 66a5 a4 8b8decf3ffff 81c1df000000 }
            // n = 6, score = 100
            //   be????????           |                     
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   66a5                 | movsw               word ptr es:[edi], word ptr [esi]
            //   a4                   | movsb               byte ptr es:[edi], byte ptr [esi]
            //   8b8decf3ffff         | mov                 ecx, dword ptr [ebp - 0xc14]
            //   81c1df000000         | add                 ecx, 0xdf

        $sequence_14 = { 83c201 8995a4f3ffff 8b85b0f3ffff 8a08 }
            // n = 4, score = 100
            //   83c201               | add                 edx, 1
            //   8995a4f3ffff         | mov                 dword ptr [ebp - 0xc5c], edx
            //   8b85b0f3ffff         | mov                 eax, dword ptr [ebp - 0xc50]
            //   8a08                 | mov                 cl, byte ptr [eax]

        $sequence_15 = { 83e03f c1ff06 6bd830 8b04bdc0c00110 }
            // n = 4, score = 100
            //   83e03f               | and                 eax, 0x3f
            //   c1ff06               | sar                 edi, 6
            //   6bd830               | imul                ebx, eax, 0x30
            //   8b04bdc0c00110       | mov                 eax, dword ptr [edi*4 + 0x1001c0c0]

    condition:
        7 of them and filesize < 270336
}