rule win_wipbot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.wipbot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.wipbot"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 48 89cf 0f847f010000 48 8d4c2430 e8???????? }
            // n = 6, score = 100
            //   48                   | dec                 eax
            //   89cf                 | mov                 edi, ecx
            //   0f847f010000         | je                  0x185
            //   48                   | dec                 eax
            //   8d4c2430             | lea                 ecx, [esp + 0x30]
            //   e8????????           |                     

        $sequence_1 = { c68424a10200000b c68424a20200007b 31c0 c68424a302000069 c68424a402000060 c68424a50200007a c68424a60200000e }
            // n = 7, score = 100
            //   c68424a10200000b     | mov                 byte ptr [esp + 0x2a1], 0xb
            //   c68424a20200007b     | mov                 byte ptr [esp + 0x2a2], 0x7b
            //   31c0                 | xor                 eax, eax
            //   c68424a302000069     | mov                 byte ptr [esp + 0x2a3], 0x69
            //   c68424a402000060     | mov                 byte ptr [esp + 0x2a4], 0x60
            //   c68424a50200007a     | mov                 byte ptr [esp + 0x2a5], 0x7a
            //   c68424a60200000e     | mov                 byte ptr [esp + 0x2a6], 0xe

        $sequence_2 = { 48 8d0d86ffffff e8???????? 4c 8d442440 895c2420 }
            // n = 6, score = 100
            //   48                   | dec                 eax
            //   8d0d86ffffff         | lea                 ecx, [0xffffff86]
            //   e8????????           |                     
            //   4c                   | dec                 esp
            //   8d442440             | lea                 eax, [esp + 0x40]
            //   895c2420             | mov                 dword ptr [esp + 0x20], ebx

        $sequence_3 = { 89c7 7504 31c0 eb72 4c 8b03 4d }
            // n = 7, score = 100
            //   89c7                 | mov                 edi, eax
            //   7504                 | jne                 6
            //   31c0                 | xor                 eax, eax
            //   eb72                 | jmp                 0x74
            //   4c                   | dec                 esp
            //   8b03                 | mov                 eax, dword ptr [ebx]
            //   4d                   | dec                 ebp

        $sequence_4 = { 48 ffc0 3211 83f22e 48 83f804 }
            // n = 6, score = 100
            //   48                   | dec                 eax
            //   ffc0                 | inc                 eax
            //   3211                 | xor                 dl, byte ptr [ecx]
            //   83f22e               | xor                 edx, 0x2e
            //   48                   | dec                 eax
            //   83f804               | cmp                 eax, 4

        $sequence_5 = { 89c7 750c e8???????? 0d00005e00 eb45 48 8b442438 }
            // n = 7, score = 100
            //   89c7                 | mov                 edi, eax
            //   750c                 | jne                 0xe
            //   e8????????           |                     
            //   0d00005e00           | or                  eax, 0x5e0000
            //   eb45                 | jmp                 0x47
            //   48                   | dec                 eax
            //   8b442438             | mov                 eax, dword ptr [esp + 0x38]

        $sequence_6 = { 48 85c0 7437 45 31c9 }
            // n = 5, score = 100
            //   48                   | dec                 eax
            //   85c0                 | test                eax, eax
            //   7437                 | je                  0x39
            //   45                   | inc                 ebp
            //   31c9                 | xor                 ecx, ecx

        $sequence_7 = { 66c704430000 b801000000 eb02 31c0 48 83c428 5b }
            // n = 7, score = 100
            //   66c704430000         | mov                 word ptr [ebx + eax*2], 0
            //   b801000000           | mov                 eax, 1
            //   eb02                 | jmp                 4
            //   31c0                 | xor                 eax, eax
            //   48                   | dec                 eax
            //   83c428               | add                 esp, 0x28
            //   5b                   | pop                 ebx

        $sequence_8 = { ba08000000 48 89f9 41 ffd1 eb31 }
            // n = 6, score = 100
            //   ba08000000           | mov                 edx, 8
            //   48                   | dec                 eax
            //   89f9                 | mov                 ecx, edi
            //   41                   | inc                 ecx
            //   ffd1                 | call                ecx
            //   eb31                 | jmp                 0x33

        $sequence_9 = { 81ce00009f00 e9???????? 8b44bdc8 e8???????? }
            // n = 4, score = 100
            //   81ce00009f00         | or                  esi, 0x9f0000
            //   e9????????           |                     
            //   8b44bdc8             | mov                 eax, dword ptr [ebp + edi*4 - 0x38]
            //   e8????????           |                     

    condition:
        7 of them and filesize < 253952
}