rule win_xbot_pos_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.xbot_pos."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.xbot_pos"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8945ec 837dec00 7410 8b4dec e8???????? }
            // n = 5, score = 100
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax
            //   837dec00             | cmp                 dword ptr [ebp - 0x14], 0
            //   7410                 | je                  0x12
            //   8b4dec               | mov                 ecx, dword ptr [ebp - 0x14]
            //   e8????????           |                     

        $sequence_1 = { 50 8b4d08 e8???????? 50 8b4dec e8???????? 8b08 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   e8????????           |                     
            //   50                   | push                eax
            //   8b4dec               | mov                 ecx, dword ptr [ebp - 0x14]
            //   e8????????           |                     
            //   8b08                 | mov                 ecx, dword ptr [eax]

        $sequence_2 = { e8???????? 8d8df8fcffff e8???????? 8d85d8fcffff 50 8b4d08 e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8d8df8fcffff         | lea                 ecx, [ebp - 0x308]
            //   e8????????           |                     
            //   8d85d8fcffff         | lea                 eax, [ebp - 0x328]
            //   50                   | push                eax
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   e8????????           |                     

        $sequence_3 = { 8b4508 83e03f 6bc830 8b1495e0465600 03d1 b801000000 6bc800 }
            // n = 7, score = 100
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   83e03f               | and                 eax, 0x3f
            //   6bc830               | imul                ecx, eax, 0x30
            //   8b1495e0465600       | mov                 edx, dword ptr [edx*4 + 0x5646e0]
            //   03d1                 | add                 edx, ecx
            //   b801000000           | mov                 eax, 1
            //   6bc800               | imul                ecx, eax, 0

        $sequence_4 = { 8b4d0c c1f906 8b550c 83e23f 6bc230 8b0c8de0465600 8b55dc }
            // n = 7, score = 100
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   c1f906               | sar                 ecx, 6
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   83e23f               | and                 edx, 0x3f
            //   6bc230               | imul                eax, edx, 0x30
            //   8b0c8de0465600       | mov                 ecx, dword ptr [ecx*4 + 0x5646e0]
            //   8b55dc               | mov                 edx, dword ptr [ebp - 0x24]

        $sequence_5 = { e8???????? 0fb68593feffff 85c0 7431 8d4580 50 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   0fb68593feffff       | movzx               eax, byte ptr [ebp - 0x16d]
            //   85c0                 | test                eax, eax
            //   7431                 | je                  0x33
            //   8d4580               | lea                 eax, [ebp - 0x80]
            //   50                   | push                eax

        $sequence_6 = { 6bc830 8b1495e0465600 0fb6440a28 2580000000 7541 8b4de4 51 }
            // n = 7, score = 100
            //   6bc830               | imul                ecx, eax, 0x30
            //   8b1495e0465600       | mov                 edx, dword ptr [edx*4 + 0x5646e0]
            //   0fb6440a28           | movzx               eax, byte ptr [edx + ecx + 0x28]
            //   2580000000           | and                 eax, 0x80
            //   7541                 | jne                 0x43
            //   8b4de4               | mov                 ecx, dword ptr [ebp - 0x1c]
            //   51                   | push                ecx

        $sequence_7 = { 8d850cfdffff 50 8b4d08 e8???????? 89851cfcffff }
            // n = 5, score = 100
            //   8d850cfdffff         | lea                 eax, [ebp - 0x2f4]
            //   50                   | push                eax
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   e8????????           |                     
            //   89851cfcffff         | mov                 dword ptr [ebp - 0x3e4], eax

        $sequence_8 = { 8945ec 837dec00 7417 8b45f8 83780800 740e 8b45ec }
            // n = 7, score = 100
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax
            //   837dec00             | cmp                 dword ptr [ebp - 0x14], 0
            //   7417                 | je                  0x19
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   83780800             | cmp                 dword ptr [eax + 8], 0
            //   740e                 | je                  0x10
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]

        $sequence_9 = { 00a58d49000e 8a4900 268b4900 52 8c4900 7e8d 49 }
            // n = 7, score = 100
            //   00a58d49000e         | add                 byte ptr [ebp + 0xe00498d], ah
            //   8a4900               | mov                 cl, byte ptr [ecx]
            //   268b4900             | mov                 ecx, dword ptr es:[ecx]
            //   52                   | push                edx
            //   8c4900               | mov                 word ptr [ecx], cs
            //   7e8d                 | jle                 0xffffff8f
            //   49                   | dec                 ecx

    condition:
        7 of them and filesize < 3031040
}