rule win_xfsadm_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.xfsadm."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.xfsadm"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 ffd6 68???????? 6a00 ffd7 85c0 740c }
            // n = 7, score = 100
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   68????????           |                     
            //   6a00                 | push                0
            //   ffd7                 | call                edi
            //   85c0                 | test                eax, eax
            //   740c                 | je                  0xe

        $sequence_1 = { e8???????? 83c404 8b7508 c7430c00000000 c7431000000000 c7431400000000 8d4e01 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   c7430c00000000       | mov                 dword ptr [ebx + 0xc], 0
            //   c7431000000000       | mov                 dword ptr [ebx + 0x10], 0
            //   c7431400000000       | mov                 dword ptr [ebx + 0x14], 0
            //   8d4e01               | lea                 ecx, [esi + 1]

        $sequence_2 = { be01000000 eb02 33f6 8b4508 83c9ff 83c0f0 }
            // n = 6, score = 100
            //   be01000000           | mov                 esi, 1
            //   eb02                 | jmp                 4
            //   33f6                 | xor                 esi, esi
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   83c9ff               | or                  ecx, 0xffffffff
            //   83c0f0               | add                 eax, -0x10

        $sequence_3 = { ffb6ec000000 8bd8 ffb6d0000000 53 e8???????? 8b86d0000000 8d8ed4000000 }
            // n = 7, score = 100
            //   ffb6ec000000         | push                dword ptr [esi + 0xec]
            //   8bd8                 | mov                 ebx, eax
            //   ffb6d0000000         | push                dword ptr [esi + 0xd0]
            //   53                   | push                ebx
            //   e8????????           |                     
            //   8b86d0000000         | mov                 eax, dword ptr [esi + 0xd0]
            //   8d8ed4000000         | lea                 ecx, [esi + 0xd4]

        $sequence_4 = { 5f 5e 5d c20400 8d4e0c e8???????? 50 }
            // n = 7, score = 100
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   c20400               | ret                 4
            //   8d4e0c               | lea                 ecx, [esi + 0xc]
            //   e8????????           |                     
            //   50                   | push                eax

        $sequence_5 = { 75d9 ff06 ebd5 8a1f 80fb22 7405 80fb27 }
            // n = 7, score = 100
            //   75d9                 | jne                 0xffffffdb
            //   ff06                 | inc                 dword ptr [esi]
            //   ebd5                 | jmp                 0xffffffd7
            //   8a1f                 | mov                 bl, byte ptr [edi]
            //   80fb22               | cmp                 bl, 0x22
            //   7405                 | je                  7
            //   80fb27               | cmp                 bl, 0x27

        $sequence_6 = { 85ff 0f857f010000 53 68d80f0000 e8???????? 68d80f0000 }
            // n = 6, score = 100
            //   85ff                 | test                edi, edi
            //   0f857f010000         | jne                 0x185
            //   53                   | push                ebx
            //   68d80f0000           | push                0xfd8
            //   e8????????           |                     
            //   68d80f0000           | push                0xfd8

        $sequence_7 = { c702???????? e9???????? 8b86fc000000 81c6fc000000 }
            // n = 4, score = 100
            //   c702????????         |                     
            //   e9????????           |                     
            //   8b86fc000000         | mov                 eax, dword ptr [esi + 0xfc]
            //   81c6fc000000         | add                 esi, 0xfc

        $sequence_8 = { 33cc e8???????? 8be5 5d c21000 c605????????01 33c0 }
            // n = 7, score = 100
            //   33cc                 | xor                 ecx, esp
            //   e8????????           |                     
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c21000               | ret                 0x10
            //   c605????????01       |                     
            //   33c0                 | xor                 eax, eax

        $sequence_9 = { b904000000 6a08 6a00 68e8030000 c7400201000000 a1???????? 6a00 }
            // n = 7, score = 100
            //   b904000000           | mov                 ecx, 4
            //   6a08                 | push                8
            //   6a00                 | push                0
            //   68e8030000           | push                0x3e8
            //   c7400201000000       | mov                 dword ptr [eax + 2], 1
            //   a1????????           |                     
            //   6a00                 | push                0

    condition:
        7 of them and filesize < 566272
}