rule win_xiangoop_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.xiangoop."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.xiangoop"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b45f4 0fb60c08 81e1ff000000 0bd1 b804000000 }
            // n = 5, score = 100
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   0fb60c08             | movzx               ecx, byte ptr [eax + ecx]
            //   81e1ff000000         | and                 ecx, 0xff
            //   0bd1                 | or                  edx, ecx
            //   b804000000           | mov                 eax, 4

        $sequence_1 = { 8945ec 837dec00 750e 8b55f8 83c214 8955f8 }
            // n = 6, score = 100
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax
            //   837dec00             | cmp                 dword ptr [ebp - 0x14], 0
            //   750e                 | jne                 0x10
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   83c214               | add                 edx, 0x14
            //   8955f8               | mov                 dword ptr [ebp - 8], edx

        $sequence_2 = { 81e2ff000000 8b45f8 c1e808 8b75f8 }
            // n = 4, score = 100
            //   81e2ff000000         | and                 edx, 0xff
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   c1e808               | shr                 eax, 8
            //   8b75f8               | mov                 esi, dword ptr [ebp - 8]

        $sequence_3 = { 8b55f0 83c204 8955f0 8b45fc 8b4df0 8b11 8910 }
            // n = 7, score = 100
            //   8b55f0               | mov                 edx, dword ptr [ebp - 0x10]
            //   83c204               | add                 edx, 4
            //   8955f0               | mov                 dword ptr [ebp - 0x10], edx
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   8b11                 | mov                 edx, dword ptr [ecx]
            //   8910                 | mov                 dword ptr [eax], edx

        $sequence_4 = { 891408 b904000000 6bd103 b804000000 6bc806 8b45fc }
            // n = 6, score = 100
            //   891408               | mov                 dword ptr [eax + ecx], edx
            //   b904000000           | mov                 ecx, 4
            //   6bd103               | imul                edx, ecx, 3
            //   b804000000           | mov                 eax, 4
            //   6bc806               | imul                ecx, eax, 6
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]

        $sequence_5 = { 8955f8 837df800 7741 7206 837df40a 7339 8b4d08 }
            // n = 7, score = 100
            //   8955f8               | mov                 dword ptr [ebp - 8], edx
            //   837df800             | cmp                 dword ptr [ebp - 8], 0
            //   7741                 | ja                  0x43
            //   7206                 | jb                  8
            //   837df40a             | cmp                 dword ptr [ebp - 0xc], 0xa
            //   7339                 | jae                 0x3b
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]

        $sequence_6 = { 8b55fc 330c02 894dec e9???????? 8b45dc }
            // n = 5, score = 100
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   330c02               | xor                 ecx, dword ptr [edx + eax]
            //   894dec               | mov                 dword ptr [ebp - 0x14], ecx
            //   e9????????           |                     
            //   8b45dc               | mov                 eax, dword ptr [ebp - 0x24]

        $sequence_7 = { c745e408430110 e9???????? 894de0 c745e408430110 e9???????? c745e404430110 e9???????? }
            // n = 7, score = 100
            //   c745e408430110       | mov                 dword ptr [ebp - 0x1c], 0x10014308
            //   e9????????           |                     
            //   894de0               | mov                 dword ptr [ebp - 0x20], ecx
            //   c745e408430110       | mov                 dword ptr [ebp - 0x1c], 0x10014308
            //   e9????????           |                     
            //   c745e404430110       | mov                 dword ptr [ebp - 0x1c], 0x10014304
            //   e9????????           |                     

        $sequence_8 = { 6bc203 8b5510 884c020c 8be5 }
            // n = 4, score = 100
            //   6bc203               | imul                eax, edx, 3
            //   8b5510               | mov                 edx, dword ptr [ebp + 0x10]
            //   884c020c             | mov                 byte ptr [edx + eax + 0xc], cl
            //   8be5                 | mov                 esp, ebp

        $sequence_9 = { 0bc1 ba01000000 d1e2 8b4df4 0fb6541110 81e2ff000000 c1e208 }
            // n = 7, score = 100
            //   0bc1                 | or                  eax, ecx
            //   ba01000000           | mov                 edx, 1
            //   d1e2                 | shl                 edx, 1
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   0fb6541110           | movzx               edx, byte ptr [ecx + edx + 0x10]
            //   81e2ff000000         | and                 edx, 0xff
            //   c1e208               | shl                 edx, 8

    condition:
        7 of them and filesize < 246784
}