rule win_xorist_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.xorist."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.xorist"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7529 663bc3 751e 0fb7447dfe }
            // n = 4, score = 100
            //   7529                 | jne                 0x2b
            //   663bc3               | cmp                 ax, bx
            //   751e                 | jne                 0x20
            //   0fb7447dfe           | movzx               eax, word ptr [ebp + edi*2 - 2]

        $sequence_1 = { 6a04 ff7654 ff7650 e8???????? }
            // n = 4, score = 100
            //   6a04                 | push                4
            //   ff7654               | push                dword ptr [esi + 0x54]
            //   ff7650               | push                dword ptr [esi + 0x50]
            //   e8????????           |                     

        $sequence_2 = { 8d48f9 8954241c 83e10f c1c205 }
            // n = 4, score = 100
            //   8d48f9               | lea                 ecx, [eax - 7]
            //   8954241c             | mov                 dword ptr [esp + 0x1c], edx
            //   83e10f               | and                 ecx, 0xf
            //   c1c205               | rol                 edx, 5

        $sequence_3 = { 57 8d7c240c 8907 33c0 }
            // n = 4, score = 100
            //   57                   | push                edi
            //   8d7c240c             | lea                 edi, [esp + 0xc]
            //   8907                 | mov                 dword ptr [edi], eax
            //   33c0                 | xor                 eax, eax

        $sequence_4 = { 034c241c 2bc3 1b4c2424 2b442420 }
            // n = 4, score = 100
            //   034c241c             | add                 ecx, dword ptr [esp + 0x1c]
            //   2bc3                 | sub                 eax, ebx
            //   1b4c2424             | sbb                 ecx, dword ptr [esp + 0x24]
            //   2b442420             | sub                 eax, dword ptr [esp + 0x20]

        $sequence_5 = { 117e04 5f 5e 5b }
            // n = 4, score = 100
            //   117e04               | adc                 dword ptr [esi + 4], edi
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx

        $sequence_6 = { 8b4c2418 d1c2 8914ae 8b6c2420 }
            // n = 4, score = 100
            //   8b4c2418             | mov                 ecx, dword ptr [esp + 0x18]
            //   d1c2                 | rol                 edx, 1
            //   8914ae               | mov                 dword ptr [esi + ebp*4], edx
            //   8b6c2420             | mov                 ebp, dword ptr [esp + 0x20]

        $sequence_7 = { 6a08 58 6838030000 89461c }
            // n = 4, score = 100
            //   6a08                 | push                8
            //   58                   | pop                 eax
            //   6838030000           | push                0x338
            //   89461c               | mov                 dword ptr [esi + 0x1c], eax

    condition:
        7 of them and filesize < 1402880
}