rule win_xpan_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.xpan."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.xpan"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c002 894108 b8ffffffff 6689450c 8b4108 3b410c 0f83e6030000 }
            // n = 7, score = 400
            //   83c002               | add                 eax, 2
            //   894108               | mov                 dword ptr [ecx + 8], eax
            //   b8ffffffff           | mov                 eax, 0xffffffff
            //   6689450c             | mov                 word ptr [ebp + 0xc], ax
            //   8b4108               | mov                 eax, dword ptr [ecx + 8]
            //   3b410c               | cmp                 eax, dword ptr [ecx + 0xc]
            //   0f83e6030000         | jae                 0x3ec

        $sequence_1 = { 740a 8b5c2444 c6450000 89ee 84d2 748c 8b6c2450 }
            // n = 7, score = 400
            //   740a                 | je                  0xc
            //   8b5c2444             | mov                 ebx, dword ptr [esp + 0x44]
            //   c6450000             | mov                 byte ptr [ebp], 0
            //   89ee                 | mov                 esi, ebp
            //   84d2                 | test                dl, dl
            //   748c                 | je                  0xffffff8e
            //   8b6c2450             | mov                 ebp, dword ptr [esp + 0x50]

        $sequence_2 = { 0f8313040000 0fb700 6683f8ff 0f8403030000 }
            // n = 4, score = 400
            //   0f8313040000         | jae                 0x419
            //   0fb700               | movzx               eax, word ptr [eax]
            //   6683f8ff             | cmp                 ax, -1
            //   0f8403030000         | je                  0x309

        $sequence_3 = { c744247400000000 c744247cffffffff 89442454 8b8424a0000000 2500600000 89442420 89442458 }
            // n = 7, score = 400
            //   c744247400000000     | mov                 dword ptr [esp + 0x74], 0
            //   c744247cffffffff     | mov                 dword ptr [esp + 0x7c], 0xffffffff
            //   89442454             | mov                 dword ptr [esp + 0x54], eax
            //   8b8424a0000000       | mov                 eax, dword ptr [esp + 0xa0]
            //   2500600000           | and                 eax, 0x6000
            //   89442420             | mov                 dword ptr [esp + 0x20], eax
            //   89442458             | mov                 dword ptr [esp + 0x58], eax

        $sequence_4 = { 0f848d020000 66894514 31c0 38d8 0f8427feffff 8b4d08 }
            // n = 6, score = 400
            //   0f848d020000         | je                  0x293
            //   66894514             | mov                 word ptr [ebp + 0x14], ax
            //   31c0                 | xor                 eax, eax
            //   38d8                 | cmp                 al, bl
            //   0f8427feffff         | je                  0xfffffe2d
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]

        $sequence_5 = { 0fb65610 89fb 31c9 31ff 885dd0 8d7600 8dbc2700000000 }
            // n = 7, score = 400
            //   0fb65610             | movzx               edx, byte ptr [esi + 0x10]
            //   89fb                 | mov                 ebx, edi
            //   31c9                 | xor                 ecx, ecx
            //   31ff                 | xor                 edi, edi
            //   885dd0               | mov                 byte ptr [ebp - 0x30], bl
            //   8d7600               | lea                 esi, [esi]
            //   8dbc2700000000       | lea                 edi, [edi]

        $sequence_6 = { 8d5702 89c1 0f44fa 00c1 83df03 29ef 0f844dd3ffff }
            // n = 7, score = 400
            //   8d5702               | lea                 edx, [edi + 2]
            //   89c1                 | mov                 ecx, eax
            //   0f44fa               | cmove               edi, edx
            //   00c1                 | add                 cl, al
            //   83df03               | sbb                 edi, 3
            //   29ef                 | sub                 edi, ebp
            //   0f844dd3ffff         | je                  0xffffd353

        $sequence_7 = { e9???????? 85c0 74e0 31f6 e9???????? 89eb }
            // n = 6, score = 400
            //   e9????????           |                     
            //   85c0                 | test                eax, eax
            //   74e0                 | je                  0xffffffe2
            //   31f6                 | xor                 esi, esi
            //   e9????????           |                     
            //   89eb                 | mov                 ebx, ebp

        $sequence_8 = { 83e101 742b b901000000 83c001 0fb610 80fa20 }
            // n = 6, score = 400
            //   83e101               | and                 ecx, 1
            //   742b                 | je                  0x2d
            //   b901000000           | mov                 ecx, 1
            //   83c001               | add                 eax, 1
            //   0fb610               | movzx               edx, byte ptr [eax]
            //   80fa20               | cmp                 dl, 0x20

        $sequence_9 = { 757d 85f6 0f84d8000000 f744245400180000 0f84ca000000 c6450000 84d2 }
            // n = 7, score = 400
            //   757d                 | jne                 0x7f
            //   85f6                 | test                esi, esi
            //   0f84d8000000         | je                  0xde
            //   f744245400180000     | test                dword ptr [esp + 0x54], 0x1800
            //   0f84ca000000         | je                  0xd0
            //   c6450000             | mov                 byte ptr [ebp], 0
            //   84d2                 | test                dl, dl

    condition:
        7 of them and filesize < 3235840
}