rule win_xxmm_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.xxmm."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.xxmm"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85c9 7451 53 56 57 }
            // n = 5, score = 600
            //   85c9                 | test                ecx, ecx
            //   7451                 | je                  0x53
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi

        $sequence_1 = { 0fb6d2 7206 8d7c17e0 eb02 }
            // n = 4, score = 600
            //   0fb6d2               | movzx               edx, dl
            //   7206                 | jb                  8
            //   8d7c17e0             | lea                 edi, [edi + edx - 0x20]
            //   eb02                 | jmp                 4

        $sequence_2 = { 8b4c111c 8d0481 8b0410 03c2 eb12 8b07 }
            // n = 6, score = 600
            //   8b4c111c             | mov                 ecx, dword ptr [ecx + edx + 0x1c]
            //   8d0481               | lea                 eax, [ecx + eax*4]
            //   8b0410               | mov                 eax, dword ptr [eax + edx]
            //   03c2                 | add                 eax, edx
            //   eb12                 | jmp                 0x14
            //   8b07                 | mov                 eax, dword ptr [edi]

        $sequence_3 = { 4f 81cf00ffffff 47 8d040f 0fb610 035510 81e2ff000080 }
            // n = 7, score = 600
            //   4f                   | dec                 edi
            //   81cf00ffffff         | or                  edi, 0xffffff00
            //   47                   | inc                 edi
            //   8d040f               | lea                 eax, [edi + ecx]
            //   0fb610               | movzx               edx, byte ptr [eax]
            //   035510               | add                 edx, dword ptr [ebp + 0x10]
            //   81e2ff000080         | and                 edx, 0x800000ff

        $sequence_4 = { e8???????? 8d1c07 8b7320 8bcf e8???????? }
            // n = 5, score = 600
            //   e8????????           |                     
            //   8d1c07               | lea                 ebx, [edi + eax]
            //   8b7320               | mov                 esi, dword ptr [ebx + 0x20]
            //   8bcf                 | mov                 ecx, edi
            //   e8????????           |                     

        $sequence_5 = { 5b c3 53 8d5804 e8???????? ff33 }
            // n = 6, score = 600
            //   5b                   | pop                 ebx
            //   c3                   | ret                 
            //   53                   | push                ebx
            //   8d5804               | lea                 ebx, [eax + 4]
            //   e8????????           |                     
            //   ff33                 | push                dword ptr [ebx]

        $sequence_6 = { 8b440878 8b7c0820 8b540824 03f9 03d1 8955f8 }
            // n = 6, score = 600
            //   8b440878             | mov                 eax, dword ptr [eax + ecx + 0x78]
            //   8b7c0820             | mov                 edi, dword ptr [eax + ecx + 0x20]
            //   8b540824             | mov                 edx, dword ptr [eax + ecx + 0x24]
            //   03f9                 | add                 edi, ecx
            //   03d1                 | add                 edx, ecx
            //   8955f8               | mov                 dword ptr [ebp - 8], edx

        $sequence_7 = { 0f8481000000 8b96a0000000 0355f8 8b4204 }
            // n = 4, score = 600
            //   0f8481000000         | je                  0x87
            //   8b96a0000000         | mov                 edx, dword ptr [esi + 0xa0]
            //   0355f8               | add                 edx, dword ptr [ebp - 8]
            //   8b4204               | mov                 eax, dword ptr [edx + 4]

        $sequence_8 = { 8b540e1c 8d0482 03c1 81fb8e4e0eec 7509 8b00 03c1 }
            // n = 7, score = 600
            //   8b540e1c             | mov                 edx, dword ptr [esi + ecx + 0x1c]
            //   8d0482               | lea                 eax, [edx + eax*4]
            //   03c1                 | add                 eax, ecx
            //   81fb8e4e0eec         | cmp                 ebx, 0xec0e4e8e
            //   7509                 | jne                 0xb
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   03c1                 | add                 eax, ecx

        $sequence_9 = { 47 8d040f 0fb610 035510 }
            // n = 4, score = 600
            //   47                   | inc                 edi
            //   8d040f               | lea                 eax, [edi + ecx]
            //   0fb610               | movzx               edx, byte ptr [eax]
            //   035510               | add                 edx, dword ptr [ebp + 0x10]

    condition:
        7 of them and filesize < 540672
}