rule win_zedhou_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.zedhou."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.zedhou"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d55e0 52 ff15???????? 8bf0 4e 83fe10 7206 }
            // n = 7, score = 100
            //   8d55e0               | lea                 edx, [ebp - 0x20]
            //   52                   | push                edx
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   4e                   | dec                 esi
            //   83fe10               | cmp                 esi, 0x10
            //   7206                 | jb                  8

        $sequence_1 = { 8b3d???????? 894594 ffd7 8b4594 83c605 7077 3bc6 }
            // n = 7, score = 100
            //   8b3d????????         |                     
            //   894594               | mov                 dword ptr [ebp - 0x6c], eax
            //   ffd7                 | call                edi
            //   8b4594               | mov                 eax, dword ptr [ebp - 0x6c]
            //   83c605               | add                 esi, 5
            //   7077                 | jo                  0x79
            //   3bc6                 | cmp                 eax, esi

        $sequence_2 = { 59 56 68b8351722 e8???????? 59 }
            // n = 5, score = 100
            //   59                   | pop                 ecx
            //   56                   | push                esi
            //   68b8351722           | push                0x221735b8
            //   e8????????           |                     
            //   59                   | pop                 ecx

        $sequence_3 = { e8???????? 59 85c0 59 743f 6874fb1722 56 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   85c0                 | test                eax, eax
            //   59                   | pop                 ecx
            //   743f                 | je                  0x41
            //   6874fb1722           | push                0x2217fb74
            //   56                   | push                esi

        $sequence_4 = { 8b4d08 8b516c 52 68???????? ff15???????? 8bd0 }
            // n = 6, score = 100
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8b516c               | mov                 edx, dword ptr [ecx + 0x6c]
            //   52                   | push                edx
            //   68????????           |                     
            //   ff15????????         |                     
            //   8bd0                 | mov                 edx, eax

        $sequence_5 = { ff15???????? 83c414 c745fc31000000 68???????? 8b4d08 8b5154 52 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   83c414               | add                 esp, 0x14
            //   c745fc31000000       | mov                 dword ptr [ebp - 4], 0x31
            //   68????????           |                     
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8b5154               | mov                 edx, dword ptr [ecx + 0x54]
            //   52                   | push                edx

        $sequence_6 = { 8b4620 a801 740f 8b06 }
            // n = 4, score = 100
            //   8b4620               | mov                 eax, dword ptr [esi + 0x20]
            //   a801                 | test                al, 1
            //   740f                 | je                  0x11
            //   8b06                 | mov                 eax, dword ptr [esi]

        $sequence_7 = { c20800 836c240434 e9???????? 8b442404 56 ff74240c 8d70b0 }
            // n = 7, score = 100
            //   c20800               | ret                 8
            //   836c240434           | sub                 dword ptr [esp + 4], 0x34
            //   e9????????           |                     
            //   8b442404             | mov                 eax, dword ptr [esp + 4]
            //   56                   | push                esi
            //   ff74240c             | push                dword ptr [esp + 0xc]
            //   8d70b0               | lea                 esi, [eax - 0x50]

        $sequence_8 = { 59 8945f8 0f8414010000 8b3d???????? 689c251822 50 ffd7 }
            // n = 7, score = 100
            //   59                   | pop                 ecx
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   0f8414010000         | je                  0x11a
            //   8b3d????????         |                     
            //   689c251822           | push                0x2218259c
            //   50                   | push                eax
            //   ffd7                 | call                edi

        $sequence_9 = { 8b01 ff502c 8dbedc000000 895dfc 8bcf e8???????? 6685c0 }
            // n = 7, score = 100
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   ff502c               | call                dword ptr [eax + 0x2c]
            //   8dbedc000000         | lea                 edi, [esi + 0xdc]
            //   895dfc               | mov                 dword ptr [ebp - 4], ebx
            //   8bcf                 | mov                 ecx, edi
            //   e8????????           |                     
            //   6685c0               | test                ax, ax

    condition:
        7 of them and filesize < 499712
}