rule win_zenar_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.zenar."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.zenar"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6bc838 8b049598ae4300 f644082801 740b 56 e8???????? }
            // n = 6, score = 100
            //   6bc838               | imul                ecx, eax, 0x38
            //   8b049598ae4300       | mov                 eax, dword ptr [edx*4 + 0x43ae98]
            //   f644082801           | test                byte ptr [eax + ecx + 0x28], 1
            //   740b                 | je                  0xd
            //   56                   | push                esi
            //   e8????????           |                     

        $sequence_1 = { b9???????? c605????????e6 8935???????? 8935???????? e8???????? 8b45ec 8935???????? }
            // n = 7, score = 100
            //   b9????????           |                     
            //   c605????????e6       |                     
            //   8935????????         |                     
            //   8935????????         |                     
            //   e8????????           |                     
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   8935????????         |                     

        $sequence_2 = { 8b07 33c9 66890c50 8bc7 397714 7202 8b07 }
            // n = 7, score = 100
            //   8b07                 | mov                 eax, dword ptr [edi]
            //   33c9                 | xor                 ecx, ecx
            //   66890c50             | mov                 word ptr [eax + edx*2], cx
            //   8bc7                 | mov                 eax, edi
            //   397714               | cmp                 dword ptr [edi + 0x14], esi
            //   7202                 | jb                  4
            //   8b07                 | mov                 eax, dword ptr [edi]

        $sequence_3 = { c745fc02000000 e8???????? 894604 83c408 8b45ec }
            // n = 5, score = 100
            //   c745fc02000000       | mov                 dword ptr [ebp - 4], 2
            //   e8????????           |                     
            //   894604               | mov                 dword ptr [esi + 4], eax
            //   83c408               | add                 esp, 8
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]

        $sequence_4 = { c9 c21400 55 8bec 83ec10 8d45f8 53 }
            // n = 7, score = 100
            //   c9                   | leave               
            //   c21400               | ret                 0x14
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83ec10               | sub                 esp, 0x10
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   53                   | push                ebx

        $sequence_5 = { 51 50 6a30 68???????? }
            // n = 4, score = 100
            //   51                   | push                ecx
            //   50                   | push                eax
            //   6a30                 | push                0x30
            //   68????????           |                     

        $sequence_6 = { c20400 55 8bec 8d4178 8b4d08 50 }
            // n = 6, score = 100
            //   c20400               | ret                 4
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   8d4178               | lea                 eax, [ecx + 0x78]
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   50                   | push                eax

        $sequence_7 = { e8???????? 8b45fc 83c40c 895e10 894614 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   83c40c               | add                 esp, 0xc
            //   895e10               | mov                 dword ptr [esi + 0x10], ebx
            //   894614               | mov                 dword ptr [esi + 0x14], eax

        $sequence_8 = { 6bf638 8b0c8d98ae4300 80643128fd 5f 5e c9 }
            // n = 6, score = 100
            //   6bf638               | imul                esi, esi, 0x38
            //   8b0c8d98ae4300       | mov                 ecx, dword ptr [ecx*4 + 0x43ae98]
            //   80643128fd           | and                 byte ptr [ecx + esi + 0x28], 0xfd
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   c9                   | leave               

        $sequence_9 = { 8b4de0 8845f3 85c9 7411 8b01 ff5008 }
            // n = 6, score = 100
            //   8b4de0               | mov                 ecx, dword ptr [ebp - 0x20]
            //   8845f3               | mov                 byte ptr [ebp - 0xd], al
            //   85c9                 | test                ecx, ecx
            //   7411                 | je                  0x13
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   ff5008               | call                dword ptr [eax + 8]

    condition:
        7 of them and filesize < 519168
}