rule win_zerocleare_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.zerocleare."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.zerocleare"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b8518f8ffff 8bbd14f8ffff 2bc7 c1f803 3bf0 7c83 }
            // n = 6, score = 100
            //   8b8518f8ffff         | mov                 eax, dword ptr [ebp - 0x7e8]
            //   8bbd14f8ffff         | mov                 edi, dword ptr [ebp - 0x7ec]
            //   2bc7                 | sub                 eax, edi
            //   c1f803               | sar                 eax, 3
            //   3bf0                 | cmp                 esi, eax
            //   7c83                 | jl                  0xffffff85

        $sequence_1 = { 8b3d???????? 8d85c0f7ffff 0f438dd8f7ffff 83bdd4f7ffff08 }
            // n = 4, score = 100
            //   8b3d????????         |                     
            //   8d85c0f7ffff         | lea                 eax, [ebp - 0x840]
            //   0f438dd8f7ffff       | cmovae              ecx, dword ptr [ebp - 0x828]
            //   83bdd4f7ffff08       | cmp                 dword ptr [ebp - 0x82c], 8

        $sequence_2 = { 85c0 751f ff15???????? 50 8d4c2404 e8???????? 68???????? }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   751f                 | jne                 0x21
            //   ff15????????         |                     
            //   50                   | push                eax
            //   8d4c2404             | lea                 ecx, [esp + 4]
            //   e8????????           |                     
            //   68????????           |                     

        $sequence_3 = { 8945f4 56 8b7508 57 8b13 }
            // n = 5, score = 100
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   56                   | push                esi
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   57                   | push                edi
            //   8b13                 | mov                 edx, dword ptr [ebx]

        $sequence_4 = { 660fd685e8f7ffff c7401000000000 c7401407000000 668908 c645fc04 8b9530f7ffff 83fa08 }
            // n = 7, score = 100
            //   660fd685e8f7ffff     | movq                qword ptr [ebp - 0x818], xmm0
            //   c7401000000000       | mov                 dword ptr [eax + 0x10], 0
            //   c7401407000000       | mov                 dword ptr [eax + 0x14], 7
            //   668908               | mov                 word ptr [eax], cx
            //   c645fc04             | mov                 byte ptr [ebp - 4], 4
            //   8b9530f7ffff         | mov                 edx, dword ptr [ebp - 0x8d0]
            //   83fa08               | cmp                 edx, 8

        $sequence_5 = { ffb5f4f7ffff ffb5f0f7ffff e8???????? 83c408 85c0 7409 }
            // n = 6, score = 100
            //   ffb5f4f7ffff         | push                dword ptr [ebp - 0x80c]
            //   ffb5f0f7ffff         | push                dword ptr [ebp - 0x810]
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   85c0                 | test                eax, eax
            //   7409                 | je                  0xb

        $sequence_6 = { c745cc00000000 8b4104 8b7c1824 8b741820 85ff 7c19 }
            // n = 6, score = 100
            //   c745cc00000000       | mov                 dword ptr [ebp - 0x34], 0
            //   8b4104               | mov                 eax, dword ptr [ecx + 4]
            //   8b7c1824             | mov                 edi, dword ptr [eax + ebx + 0x24]
            //   8b741820             | mov                 esi, dword ptr [eax + ebx + 0x20]
            //   85ff                 | test                edi, edi
            //   7c19                 | jl                  0x1b

        $sequence_7 = { 6b45e430 8945e0 8d80f0d64400 8945e4 803800 8bc8 7435 }
            // n = 7, score = 100
            //   6b45e430             | imul                eax, dword ptr [ebp - 0x1c], 0x30
            //   8945e0               | mov                 dword ptr [ebp - 0x20], eax
            //   8d80f0d64400         | lea                 eax, [eax + 0x44d6f0]
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   803800               | cmp                 byte ptr [eax], 0
            //   8bc8                 | mov                 ecx, eax
            //   7435                 | je                  0x37

        $sequence_8 = { 0f85d2520000 c3 55 8bec a1???????? 334508 5d }
            // n = 7, score = 100
            //   0f85d2520000         | jne                 0x52d8
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   a1????????           |                     
            //   334508               | xor                 eax, dword ptr [ebp + 8]
            //   5d                   | pop                 ebp

        $sequence_9 = { e8???????? 83c40c 85c0 744a 6a00 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   85c0                 | test                eax, eax
            //   744a                 | je                  0x4c
            //   6a00                 | push                0

    condition:
        7 of them and filesize < 42670080
}