rule win_zeus_mailsniffer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.zeus_mailsniffer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.zeus_mailsniffer"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 81ec1c020000 56 6a1c 58 8945f0 c745f4c89d2d01 8945f8 }
            // n = 7, score = 100
            //   81ec1c020000         | sub                 esp, 0x21c
            //   56                   | push                esi
            //   6a1c                 | push                0x1c
            //   58                   | pop                 eax
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   c745f4c89d2d01       | mov                 dword ptr [ebp - 0xc], 0x12d9dc8
            //   8945f8               | mov                 dword ptr [ebp - 8], eax

        $sequence_1 = { 2b75fc 57 57 ff7510 81c6???????? 56 57 }
            // n = 7, score = 100
            //   2b75fc               | sub                 esi, dword ptr [ebp - 4]
            //   57                   | push                edi
            //   57                   | push                edi
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   81c6????????         |                     
            //   56                   | push                esi
            //   57                   | push                edi

        $sequence_2 = { c20400 a1???????? 89442430 8d842450020000 50 c744242cf54f2d01 c744243041512d01 }
            // n = 7, score = 100
            //   c20400               | ret                 4
            //   a1????????           |                     
            //   89442430             | mov                 dword ptr [esp + 0x30], eax
            //   8d842450020000       | lea                 eax, [esp + 0x250]
            //   50                   | push                eax
            //   c744242cf54f2d01     | mov                 dword ptr [esp + 0x2c], 0x12d4ff5
            //   c744243041512d01     | mov                 dword ptr [esp + 0x30], 0x12d5141

        $sequence_3 = { 6800300000 50 57 53 8945e8 894dfc ff15???????? }
            // n = 7, score = 100
            //   6800300000           | push                0x3000
            //   50                   | push                eax
            //   57                   | push                edi
            //   53                   | push                ebx
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   894dfc               | mov                 dword ptr [ebp - 4], ecx
            //   ff15????????         |                     

        $sequence_4 = { 8b4508 895dec e8???????? 8b7b0c 037d08 8365fc00 }
            // n = 6, score = 100
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   895dec               | mov                 dword ptr [ebp - 0x14], ebx
            //   e8????????           |                     
            //   8b7b0c               | mov                 edi, dword ptr [ebx + 0xc]
            //   037d08               | add                 edi, dword ptr [ebp + 8]
            //   8365fc00             | and                 dword ptr [ebp - 4], 0

        $sequence_5 = { 53 8d4594 50 8d4588 }
            // n = 4, score = 100
            //   53                   | push                ebx
            //   8d4594               | lea                 eax, [ebp - 0x6c]
            //   50                   | push                eax
            //   8d4588               | lea                 eax, [ebp - 0x78]

        $sequence_6 = { 0f84a0000000 e8???????? 50 ff35???????? e8???????? 59 59 }
            // n = 7, score = 100
            //   0f84a0000000         | je                  0xa6
            //   e8????????           |                     
            //   50                   | push                eax
            //   ff35????????         |                     
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx

        $sequence_7 = { d1e8 83e701 3304bd00d02d01 33048d04992e01 42 }
            // n = 5, score = 100
            //   d1e8                 | shr                 eax, 1
            //   83e701               | and                 edi, 1
            //   3304bd00d02d01       | xor                 eax, dword ptr [edi*4 + 0x12dd000]
            //   33048d04992e01       | xor                 eax, dword ptr [ecx*4 + 0x12e9904]
            //   42                   | inc                 edx

        $sequence_8 = { 8d45dc 50 ff15???????? 66837ddc00 8b87a0902d01 7403 6a29 }
            // n = 7, score = 100
            //   8d45dc               | lea                 eax, [ebp - 0x24]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   66837ddc00           | cmp                 word ptr [ebp - 0x24], 0
            //   8b87a0902d01         | mov                 eax, dword ptr [edi + 0x12d90a0]
            //   7403                 | je                  5
            //   6a29                 | push                0x29

        $sequence_9 = { ffd7 85c0 7570 8bc6 50 8d84249c030000 }
            // n = 6, score = 100
            //   ffd7                 | call                edi
            //   85c0                 | test                eax, eax
            //   7570                 | jne                 0x72
            //   8bc6                 | mov                 eax, esi
            //   50                   | push                eax
            //   8d84249c030000       | lea                 eax, [esp + 0x39c]

    condition:
        7 of them and filesize < 368640
}