rule win_zhcat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.zhcat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.zhcat"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7537 68???????? e8???????? e9???????? 8b35???????? }
            // n = 5, score = 200
            //   7537                 | jne                 0x39
            //   68????????           |                     
            //   e8????????           |                     
            //   e9????????           |                     
            //   8b35????????         |                     

        $sequence_1 = { 53 ffd6 8945f4 8d45f0 }
            // n = 4, score = 200
            //   53                   | push                ebx
            //   ffd6                 | call                esi
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   8d45f0               | lea                 eax, [ebp - 0x10]

        $sequence_2 = { c705????????02000000 eb1c c605????????01 eb13 c705????????01000000 eb07 c605????????01 }
            // n = 7, score = 200
            //   c705????????02000000     |     
            //   eb1c                 | jmp                 0x1e
            //   c605????????01       |                     
            //   eb13                 | jmp                 0x15
            //   c705????????01000000     |     
            //   eb07                 | jmp                 9
            //   c605????????01       |                     

        $sequence_3 = { 59 e9???????? 8b36 8bce c1f905 8b0c8d40604100 }
            // n = 6, score = 200
            //   59                   | pop                 ecx
            //   e9????????           |                     
            //   8b36                 | mov                 esi, dword ptr [esi]
            //   8bce                 | mov                 ecx, esi
            //   c1f905               | sar                 ecx, 5
            //   8b0c8d40604100       | mov                 ecx, dword ptr [ecx*4 + 0x416040]

        $sequence_4 = { 83c418 53 ff750c 8bf0 8d0437 50 e8???????? }
            // n = 7, score = 200
            //   83c418               | add                 esp, 0x18
            //   53                   | push                ebx
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   8bf0                 | mov                 esi, eax
            //   8d0437               | lea                 eax, [edi + esi]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_5 = { ffd7 6a02 8945d8 58 ff7514 668945c4 ffd6 }
            // n = 7, score = 200
            //   ffd7                 | call                edi
            //   6a02                 | push                2
            //   8945d8               | mov                 dword ptr [ebp - 0x28], eax
            //   58                   | pop                 eax
            //   ff7514               | push                dword ptr [ebp + 0x14]
            //   668945c4             | mov                 word ptr [ebp - 0x3c], ax
            //   ffd6                 | call                esi

        $sequence_6 = { c1f905 8b0c8d40604100 c1e006 8d44010c 50 }
            // n = 5, score = 200
            //   c1f905               | sar                 ecx, 5
            //   8b0c8d40604100       | mov                 ecx, dword ptr [ecx*4 + 0x416040]
            //   c1e006               | shl                 eax, 6
            //   8d44010c             | lea                 eax, [ecx + eax + 0xc]
            //   50                   | push                eax

        $sequence_7 = { 68ff000000 e8???????? 59 59 8b7508 8d34f590444100 391e }
            // n = 7, score = 200
            //   68ff000000           | push                0xff
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   8d34f590444100       | lea                 esi, [esi*8 + 0x414490]
            //   391e                 | cmp                 dword ptr [esi], ebx

        $sequence_8 = { 0fb63e 0fb6c0 eb12 8b45e0 8a80044a4100 08443b1d 0fb64601 }
            // n = 7, score = 200
            //   0fb63e               | movzx               edi, byte ptr [esi]
            //   0fb6c0               | movzx               eax, al
            //   eb12                 | jmp                 0x14
            //   8b45e0               | mov                 eax, dword ptr [ebp - 0x20]
            //   8a80044a4100         | mov                 al, byte ptr [eax + 0x414a04]
            //   08443b1d             | or                  byte ptr [ebx + edi + 0x1d], al
            //   0fb64601             | movzx               eax, byte ptr [esi + 1]

        $sequence_9 = { 8bfb f3a5 66a5 7424 }
            // n = 4, score = 200
            //   8bfb                 | mov                 edi, ebx
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   66a5                 | movsw               word ptr es:[edi], word ptr [esi]
            //   7424                 | je                  0x26

    condition:
        7 of them and filesize < 376832
}