rule win_zxxz_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.zxxz."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.zxxz"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ffd6 83c40c 33c0 8bff 8a88b0005f00 }
            // n = 5, score = 100
            //   ffd6                 | call                esi
            //   83c40c               | add                 esp, 0xc
            //   33c0                 | xor                 eax, eax
            //   8bff                 | mov                 edi, edi
            //   8a88b0005f00         | mov                 cl, byte ptr [eax + 0x5f00b0]

        $sequence_1 = { 68f8000000 50 8d8c240e010000 51 6689842410010000 e8???????? }
            // n = 6, score = 100
            //   68f8000000           | push                0xf8
            //   50                   | push                eax
            //   8d8c240e010000       | lea                 ecx, [esp + 0x10e]
            //   51                   | push                ecx
            //   6689842410010000     | mov                 word ptr [esp + 0x110], ax
            //   e8????????           |                     

        $sequence_2 = { 83c404 68???????? 681c020000 57 ffd6 }
            // n = 5, score = 100
            //   83c404               | add                 esp, 4
            //   68????????           |                     
            //   681c020000           | push                0x21c
            //   57                   | push                edi
            //   ffd6                 | call                esi

        $sequence_3 = { ffd5 83c40c 68???????? 68fa000000 }
            // n = 4, score = 100
            //   ffd5                 | call                ebp
            //   83c40c               | add                 esp, 0xc
            //   68????????           |                     
            //   68fa000000           | push                0xfa

        $sequence_4 = { 52 ff15???????? 8b3d???????? 8bf0 56 6a01 6a01 }
            // n = 7, score = 100
            //   52                   | push                edx
            //   ff15????????         |                     
            //   8b3d????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   56                   | push                esi
            //   6a01                 | push                1
            //   6a01                 | push                1

        $sequence_5 = { 33c4 89842404200000 53 56 8b35???????? }
            // n = 5, score = 100
            //   33c4                 | xor                 eax, esp
            //   89842404200000       | mov                 dword ptr [esp + 0x2004], eax
            //   53                   | push                ebx
            //   56                   | push                esi
            //   8b35????????         |                     

        $sequence_6 = { 668b0d???????? 66890f bf???????? e8???????? 84c0 7407 }
            // n = 6, score = 100
            //   668b0d????????       |                     
            //   66890f               | mov                 word ptr [edi], cx
            //   bf????????           |                     
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   7407                 | je                  9

        $sequence_7 = { c605????????01 ffd3 e8???????? 6830750000 ffd3 6a01 6a00 }
            // n = 7, score = 100
            //   c605????????01       |                     
            //   ffd3                 | call                ebx
            //   e8????????           |                     
            //   6830750000           | push                0x7530
            //   ffd3                 | call                ebx
            //   6a01                 | push                1
            //   6a00                 | push                0

        $sequence_8 = { 50 56 ff15???????? 8b2d???????? 57 6800100000 53 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   56                   | push                esi
            //   ff15????????         |                     
            //   8b2d????????         |                     
            //   57                   | push                edi
            //   6800100000           | push                0x1000
            //   53                   | push                ebx

        $sequence_9 = { 83c408 85c0 752f 8d442408 }
            // n = 4, score = 100
            //   83c408               | add                 esp, 8
            //   85c0                 | test                eax, eax
            //   752f                 | jne                 0x31
            //   8d442408             | lea                 eax, [esp + 8]

    condition:
        7 of them and filesize < 4142080
}