rule osx_kitmos_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/osx.kitmos"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 49 89de ff15???????? 48 89c3 4c 89f7 }
            // n = 7, score = 100
            //   49                   | dec                 ecx
            //   89de                 | mov                 esi, ebx
            //   ff15????????         |                     
            //   48                   | dec                 eax
            //   89c3                 | mov                 ebx, eax
            //   4c                   | dec                 esp
            //   89f7                 | mov                 edi, esi

        $sequence_1 = { 48 83ec10 48 89fb 48 c745e800000000 48 }
            // n = 7, score = 100
            //   48                   | dec                 eax
            //   83ec10               | sub                 esp, 0x10
            //   48                   | dec                 eax
            //   89fb                 | mov                 ebx, edi
            //   48                   | dec                 eax
            //   c745e800000000       | mov                 dword ptr [ebp - 0x18], 0
            //   48                   | dec                 eax

        $sequence_2 = { 8d357bcb0200 48 89df 48 89c2 45 31c0 }
            // n = 7, score = 100
            //   8d357bcb0200         | lea                 esi, [0x2cb7b]
            //   48                   | dec                 eax
            //   89df                 | mov                 edi, ebx
            //   48                   | dec                 eax
            //   89c2                 | mov                 edx, eax
            //   45                   | inc                 ebp
            //   31c0                 | xor                 eax, eax

        $sequence_3 = { 8945c0 48 8d05df810200 48 8945c8 48 895dd0 }
            // n = 7, score = 100
            //   8945c0               | mov                 dword ptr [ebp - 0x40], eax
            //   48                   | dec                 eax
            //   8d05df810200         | lea                 eax, [0x281df]
            //   48                   | dec                 eax
            //   8945c8               | mov                 dword ptr [ebp - 0x38], eax
            //   48                   | dec                 eax
            //   895dd0               | mov                 dword ptr [ebp - 0x30], ebx

        $sequence_4 = { 48 8d35907d0100 48 8d5590 48 8d8d10ffffff 4c }
            // n = 7, score = 100
            //   48                   | dec                 eax
            //   8d35907d0100         | lea                 esi, [0x17d90]
            //   48                   | dec                 eax
            //   8d5590               | lea                 edx, [ebp - 0x70]
            //   48                   | dec                 eax
            //   8d8d10ffffff         | lea                 ecx, [ebp - 0xf0]
            //   4c                   | dec                 esp

        $sequence_5 = { 48 8d35e39b0200 48 8d1534de0200 48 89c1 }
            // n = 6, score = 100
            //   48                   | dec                 eax
            //   8d35e39b0200         | lea                 esi, [0x29be3]
            //   48                   | dec                 eax
            //   8d1534de0200         | lea                 edx, [0x2de34]
            //   48                   | dec                 eax
            //   89c1                 | mov                 ecx, eax

        $sequence_6 = { ba01000000 ff15???????? 48 8d35be9a0200 }
            // n = 4, score = 100
            //   ba01000000           | mov                 edx, 1
            //   ff15????????         |                     
            //   48                   | dec                 eax
            //   8d35be9a0200         | lea                 esi, [0x29abe]

        $sequence_7 = { 50 49 89d6 48 89fb 48 8d35af9a0100 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   49                   | dec                 ecx
            //   89d6                 | mov                 esi, edx
            //   48                   | dec                 eax
            //   89fb                 | mov                 ebx, edi
            //   48                   | dec                 eax
            //   8d35af9a0100         | lea                 esi, [0x19aaf]

        $sequence_8 = { 48 8d35fc690200 4c 89f7 31d2 ff15???????? }
            // n = 6, score = 100
            //   48                   | dec                 eax
            //   8d35fc690200         | lea                 esi, [0x269fc]
            //   4c                   | dec                 esp
            //   89f7                 | mov                 edi, esi
            //   31d2                 | xor                 edx, edx
            //   ff15????????         |                     

        $sequence_9 = { 4c 89f7 48 8d1de7ec0200 48 89de }
            // n = 6, score = 100
            //   4c                   | dec                 esp
            //   89f7                 | mov                 edi, esi
            //   48                   | dec                 eax
            //   8d1de7ec0200         | lea                 ebx, [0x2ece7]
            //   48                   | dec                 eax
            //   89de                 | mov                 esi, ebx

    condition:
        7 of them and filesize < 508032
}