rule osx_mokes_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/osx.mokes"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ffd0 48 8b4598 8b4da0 8b95a0feffff 8955a0 48 }
            // n = 7, score = 200
            //   ffd0                 | call                eax
            //   48                   | dec                 eax
            //   8b4598               | mov                 eax, dword ptr [ebp - 0x68]
            //   8b4da0               | mov                 ecx, dword ptr [ebp - 0x60]
            //   8b95a0feffff         | mov                 edx, dword ptr [ebp - 0x160]
            //   8955a0               | mov                 dword ptr [ebp - 0x60], edx
            //   48                   | dec                 eax

        $sequence_1 = { e8???????? 4d 89bc24d8010000 41 8b4720 85c0 7427 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   4d                   | dec                 ebp
            //   89bc24d8010000       | mov                 dword ptr [esp + 0x1d8], edi
            //   41                   | inc                 ecx
            //   8b4720               | mov                 eax, dword ptr [edi + 0x20]
            //   85c0                 | test                eax, eax
            //   7427                 | je                  0x29

        $sequence_2 = { f0832f01 0f9545dc 807ddc00 7513 49 8b7f48 be02000000 }
            // n = 7, score = 200
            //   f0832f01             | lock sub            dword ptr [edi], 1
            //   0f9545dc             | setne               byte ptr [ebp - 0x24]
            //   807ddc00             | cmp                 byte ptr [ebp - 0x24], 0
            //   7513                 | jne                 0x15
            //   49                   | dec                 ecx
            //   8b7f48               | mov                 edi, dword ptr [edi + 0x48]
            //   be02000000           | mov                 esi, 2

        $sequence_3 = { 8db578ffffff 31d2 e8???????? 48 83c468 5b 41 }
            // n = 7, score = 200
            //   8db578ffffff         | lea                 esi, [ebp - 0x88]
            //   31d2                 | xor                 edx, edx
            //   e8????????           |                     
            //   48                   | dec                 eax
            //   83c468               | add                 esp, 0x68
            //   5b                   | pop                 ebx
            //   41                   | inc                 ecx

        $sequence_4 = { e8???????? 88c3 84db 7408 4c 89f7 e8???????? }
            // n = 7, score = 200
            //   e8????????           |                     
            //   88c3                 | mov                 bl, al
            //   84db                 | test                bl, bl
            //   7408                 | je                  0xa
            //   4c                   | dec                 esp
            //   89f7                 | mov                 edi, esi
            //   e8????????           |                     

        $sequence_5 = { ff90a8000000 25???????? 41 b501 3d???????? 0f85b4020000 eb2c }
            // n = 7, score = 200
            //   ff90a8000000         | call                dword ptr [eax + 0xa8]
            //   25????????           |                     
            //   41                   | inc                 ecx
            //   b501                 | mov                 ch, 1
            //   3d????????           |                     
            //   0f85b4020000         | jne                 0x2ba
            //   eb2c                 | jmp                 0x2e

        $sequence_6 = { ff5070 48 898330010000 c7839401000003000000 c745bc03000000 48 c745c000000000 }
            // n = 7, score = 200
            //   ff5070               | call                dword ptr [eax + 0x70]
            //   48                   | dec                 eax
            //   898330010000         | mov                 dword ptr [ebx + 0x130], eax
            //   c7839401000003000000     | mov    dword ptr [ebx + 0x194], 3
            //   c745bc03000000       | mov                 dword ptr [ebp - 0x44], 3
            //   48                   | dec                 eax
            //   c745c000000000       | mov                 dword ptr [ebp - 0x40], 0

        $sequence_7 = { e8???????? 48 85db 7419 48 85c0 7414 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   48                   | dec                 eax
            //   85db                 | test                ebx, ebx
            //   7419                 | je                  0x1b
            //   48                   | dec                 eax
            //   85c0                 | test                eax, eax
            //   7414                 | je                  0x16

        $sequence_8 = { c1e820 39c8 754f 48 8b45b8 48 3b45d0 }
            // n = 7, score = 200
            //   c1e820               | shr                 eax, 0x20
            //   39c8                 | cmp                 eax, ecx
            //   754f                 | jne                 0x51
            //   48                   | dec                 eax
            //   8b45b8               | mov                 eax, dword ptr [ebp - 0x48]
            //   48                   | dec                 eax
            //   3b45d0               | cmp                 eax, dword ptr [ebp - 0x30]

        $sequence_9 = { f76138 45 31db 49 01c2 48 11d1 }
            // n = 7, score = 200
            //   f76138               | mul                 dword ptr [ecx + 0x38]
            //   45                   | inc                 ebp
            //   31db                 | xor                 ebx, ebx
            //   49                   | dec                 ecx
            //   01c2                 | add                 edx, eax
            //   48                   | dec                 eax
            //   11d1                 | adc                 ecx, edx

    condition:
        7 of them and filesize < 28742512
}