rule win_acidbox_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.acidbox."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.acidbox"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { bb0c010480 eb4b 41b800000206 413bd0 7322 483998a8000000 74e5 }
            // n = 7, score = 400
            //   bb0c010480           | dec                 ecx
            //   eb4b                 | mov                 dword ptr [ebx + 0x18], ecx
            //   41b800000206         | dec                 eax
            //   413bd0               | test                ecx, ecx
            //   7322                 | je                  0x511
            //   483998a8000000       | dec                 eax
            //   74e5                 | mov                 ecx, dword ptr [esi + 0x90]

        $sequence_1 = { 74d9 488b842420050000 488b8038010000 4885c0 750a bb0c130480 e9???????? }
            // n = 7, score = 400
            //   74d9                 | test                eax, eax
            //   488b842420050000     | cmovs               ebx, ecx
            //   488b8038010000       | lea                 edx, [esi + 1]
            //   4885c0               | mov                 ecx, 0x430
            //   750a                 | dec                 esp
            //   bb0c130480           | mov                 esi, eax
            //   e9????????           |                     

        $sequence_2 = { 881401 4401b3f4160000 664401b493bc000000 8b83f0160000 412bc6 3983f4160000 753e }
            // n = 7, score = 400
            //   881401               | dec                 eax
            //   4401b3f4160000       | mov                 ebx, dword ptr [esp + 0xc48]
            //   664401b493bc000000     | dec    eax
            //   8b83f0160000         | add                 esp, 0xc10
            //   412bc6               | inc                 ecx
            //   3983f4160000         | pop                 edi
            //   753e                 | inc                 ecx

        $sequence_3 = { c7442454ff000000 c7442458ccccf048 c744245c0000ffff c74424600fba2dcc c7442464ffffff00 c7442468cccccc00 }
            // n = 6, score = 400
            //   c7442454ff000000     | inc                 ebx
            //   c7442458ccccf048     | sub                 ebx, dword ptr [esp + esi*4 + 0x4640]
            //   c744245c0000ffff     | inc                 ecx
            //   c74424600fba2dcc     | mov                 eax, ebx
            //   c7442464ffffff00     | inc                 ecx
            //   c7442468cccccc00     | sub                 eax, eax

        $sequence_4 = { 498b07 488b5598 44896594 428834a0 498b07 488b75a8 46885ca001 }
            // n = 7, score = 400
            //   498b07               | test                eax, eax
            //   488b5598             | jg                  0x328
            //   44896594             | inc                 ecx
            //   428834a0             | mov                 ebx, 1
            //   498b07               | dec                 eax
            //   488b75a8             | arpl                cx, ax
            //   46885ca001           | inc                 bp

        $sequence_5 = { 897c2424 410fb74606 443be8 734f 488d9424d0010000 498bcf ff15???????? }
            // n = 7, score = 400
            //   897c2424             | mov                 dword ptr [edi], edi
            //   410fb74606           | mov                 dword ptr [edi + 0x10], 1
            //   443be8               | dec                 esp
            //   734f                 | lea                 ecx, [esp + 0x160]
            //   488d9424d0010000     | dec                 esp
            //   498bcf               | lea                 eax, [esp + 0x170]
            //   ff15????????         |                     

        $sequence_6 = { 450f44d3 48894da0 ba01000000 412bf2 44895588 8bce 4403d6 }
            // n = 7, score = 400
            //   450f44d3             | dec                 eax
            //   48894da0             | lea                 ecx, [esp + 0xe0]
            //   ba01000000           | call                eax
            //   412bf2               | test                eax, eax
            //   44895588             | je                  0x5fa
            //   8bce                 | mov                 eax, 0xa0031f06
            //   4403d6               | jmp                 0x646

        $sequence_7 = { 83fe03 72da 8b477c 410fb7ce 83c6fd 410fb70442 664123c8 }
            // n = 7, score = 400
            //   83fe03               | mov                 dword ptr [eax - 0x88], 0x48cccccc
            //   72da                 | mov                 dword ptr [eax - 0x84], 0xff000000
            //   8b477c               | mov                 dword ptr [eax - 0x80], 0xcccccc89
            //   410fb7ce             | mov                 dword ptr [eax - 0x7c], 0xff
            //   83c6fd               | mov                 dword ptr [eax - 0x78], 0x74cc8548
            //   410fb70442           | mov                 dword ptr [eax - 0x74], 0xff00ffff
            //   664123c8             | mov                 dword ptr [eax - 0x88], 0x6843f7

        $sequence_8 = { c745d8fdffffff 4c8b7de0 eb1a 448bf2 8bf2 c7071c000000 c745d801000000 }
            // n = 7, score = 400
            //   c745d8fdffffff       | mov                 dword ptr [ebx - 0x28], ecx
            //   4c8b7de0             | dec                 ebp
            //   eb1a                 | mov                 dword ptr [ebx - 0x20], eax
            //   448bf2               | inc                 ebp
            //   8bf2                 | mov                 esp, dword ptr [ebp + 8]
            //   c7071c000000         | xor                 edx, edx
            //   c745d801000000       | ja                  0xfffffe62

        $sequence_9 = { 8bf7 49897ba0 448bff 49897bb0 }
            // n = 4, score = 400
            //   8bf7                 | je                  0x2b
            //   49897ba0             | dec                 esp
            //   448bff               | arpl                word ptr [ecx + 0x3c], di
            //   49897bb0             | dec                 esp

    condition:
        7 of them and filesize < 589824
}