rule win_adhubllka_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.adhubllka."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.adhubllka"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 8d8dfcfcffff e8???????? 0f1085fcfcffff 8bd6 }
            // n = 5, score = 500
            //   e8????????           |                     
            //   8d8dfcfcffff         | lea                 ecx, [ebp - 0x304]
            //   e8????????           |                     
            //   0f1085fcfcffff       | movups              xmm0, xmmword ptr [ebp - 0x304]
            //   8bd6                 | mov                 edx, esi

        $sequence_1 = { 751e a1???????? 56 ffd0 33c0 5f }
            // n = 6, score = 500
            //   751e                 | jne                 0x20
            //   a1????????           |                     
            //   56                   | push                esi
            //   ffd0                 | call                eax
            //   33c0                 | xor                 eax, eax
            //   5f                   | pop                 edi

        $sequence_2 = { 50 ff5150 85c0 0f8804010000 }
            // n = 4, score = 500
            //   50                   | push                eax
            //   ff5150               | call                dword ptr [ecx + 0x50]
            //   85c0                 | test                eax, eax
            //   0f8804010000         | js                  0x10a

        $sequence_3 = { 8b8534ffffff 03c2 33f8 c1c710 03cf 33d1 c1c20c }
            // n = 7, score = 500
            //   8b8534ffffff         | mov                 eax, dword ptr [ebp - 0xcc]
            //   03c2                 | add                 eax, edx
            //   33f8                 | xor                 edi, eax
            //   c1c710               | rol                 edi, 0x10
            //   03cf                 | add                 ecx, edi
            //   33d1                 | xor                 edx, ecx
            //   c1c20c               | rol                 edx, 0xc

        $sequence_4 = { 50 6af6 ff15???????? 8b04bd68b34100 834c0318ff 33c0 eb16 }
            // n = 7, score = 500
            //   50                   | push                eax
            //   6af6                 | push                -0xa
            //   ff15????????         |                     
            //   8b04bd68b34100       | mov                 eax, dword ptr [edi*4 + 0x41b368]
            //   834c0318ff           | or                  dword ptr [ebx + eax + 0x18], 0xffffffff
            //   33c0                 | xor                 eax, eax
            //   eb16                 | jmp                 0x18

        $sequence_5 = { 660ffea530ffffff 660fefc8 8345f010 0f28d4 0f1108 8b45fc }
            // n = 6, score = 500
            //   660ffea530ffffff     | paddd               xmm4, xmmword ptr [ebp - 0xd0]
            //   660fefc8             | pxor                xmm1, xmm0
            //   8345f010             | add                 dword ptr [ebp - 0x10], 0x10
            //   0f28d4               | movaps              xmm2, xmm4
            //   0f1108               | movups              xmmword ptr [eax], xmm1
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]

        $sequence_6 = { 8945dc 8b458c 03c7 c1c207 8bc8 334d84 c1c110 }
            // n = 7, score = 500
            //   8945dc               | mov                 dword ptr [ebp - 0x24], eax
            //   8b458c               | mov                 eax, dword ptr [ebp - 0x74]
            //   03c7                 | add                 eax, edi
            //   c1c207               | rol                 edx, 7
            //   8bc8                 | mov                 ecx, eax
            //   334d84               | xor                 ecx, dword ptr [ebp - 0x7c]
            //   c1c110               | rol                 ecx, 0x10

        $sequence_7 = { 8d041e c1c007 33458c 8d3403 c1c609 }
            // n = 5, score = 500
            //   8d041e               | lea                 eax, [esi + ebx]
            //   c1c007               | rol                 eax, 7
            //   33458c               | xor                 eax, dword ptr [ebp - 0x74]
            //   8d3403               | lea                 esi, [ebx + eax]
            //   c1c609               | rol                 esi, 9

        $sequence_8 = { 0fbe05???????? c1e208 0bd0 c745d4bbaaffee 0fbe05???????? c1e208 0bd0 }
            // n = 7, score = 500
            //   0fbe05????????       |                     
            //   c1e208               | shl                 edx, 8
            //   0bd0                 | or                  edx, eax
            //   c745d4bbaaffee       | mov                 dword ptr [ebp - 0x2c], 0xeeffaabb
            //   0fbe05????????       |                     
            //   c1e208               | shl                 edx, 8
            //   0bd0                 | or                  edx, eax

        $sequence_9 = { 0f28a570feffff 0f1000 8b45f0 660ffea530ffffff 660fefc8 8345f010 0f28d4 }
            // n = 7, score = 500
            //   0f28a570feffff       | movaps              xmm4, xmmword ptr [ebp - 0x190]
            //   0f1000               | movups              xmm0, xmmword ptr [eax]
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   660ffea530ffffff     | paddd               xmm4, xmmword ptr [ebp - 0xd0]
            //   660fefc8             | pxor                xmm1, xmm0
            //   8345f010             | add                 dword ptr [ebp - 0x10], 0x10
            //   0f28d4               | movaps              xmm2, xmm4

    condition:
        7 of them and filesize < 253952
}