rule win_advisorsbot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.advisorsbot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.advisorsbot"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bc1 2bc2 d1e8 03c2 c1e808 }
            // n = 5, score = 1000
            //   8bc1                 | mov                 eax, ecx
            //   2bc2                 | sub                 eax, edx
            //   d1e8                 | shr                 eax, 1
            //   03c2                 | add                 eax, edx
            //   c1e808               | shr                 eax, 8

        $sequence_1 = { b89b01a311 f7e1 2bca d1e9 03ca }
            // n = 5, score = 800
            //   b89b01a311           | mov                 eax, 0x11a3019b
            //   f7e1                 | mul                 ecx
            //   2bca                 | sub                 ecx, edx
            //   d1e9                 | shr                 ecx, 1
            //   03ca                 | add                 ecx, edx

        $sequence_2 = { 8bc2 33d2 c1e808 f7f1 }
            // n = 4, score = 800
            //   8bc2                 | mov                 eax, edx
            //   33d2                 | xor                 edx, edx
            //   c1e808               | shr                 eax, 8
            //   f7f1                 | div                 ecx

        $sequence_3 = { 8bc2 33d2 c1e809 f7f1 }
            // n = 4, score = 800
            //   8bc2                 | mov                 eax, edx
            //   33d2                 | xor                 edx, edx
            //   c1e809               | shr                 eax, 9
            //   f7f1                 | div                 ecx

        $sequence_4 = { d1e8 03c2 33d2 c1e809 }
            // n = 4, score = 700
            //   d1e8                 | shr                 eax, 1
            //   03c2                 | add                 eax, edx
            //   33d2                 | xor                 edx, edx
            //   c1e809               | shr                 eax, 9

        $sequence_5 = { b80923ed58 f7e1 8bc1 2bc2 }
            // n = 4, score = 700
            //   b80923ed58           | mov                 eax, 0x58ed2309
            //   f7e1                 | mul                 ecx
            //   8bc1                 | mov                 eax, ecx
            //   2bc2                 | sub                 eax, edx

        $sequence_6 = { 8b442408 8b4c2408 33d2 f7f1 }
            // n = 4, score = 600
            //   8b442408             | mov                 eax, dword ptr [esp + 8]
            //   8b4c2408             | mov                 ecx, dword ptr [esp + 8]
            //   33d2                 | xor                 edx, edx
            //   f7f1                 | div                 ecx

        $sequence_7 = { 8bc2 c1e807 33d2 f7f1 }
            // n = 4, score = 600
            //   8bc2                 | mov                 eax, edx
            //   c1e807               | shr                 eax, 7
            //   33d2                 | xor                 edx, edx
            //   f7f1                 | div                 ecx

        $sequence_8 = { d1e9 03ca c1e909 33c8 }
            // n = 4, score = 600
            //   d1e9                 | shr                 ecx, 1
            //   03ca                 | add                 ecx, edx
            //   c1e909               | shr                 ecx, 9
            //   33c8                 | xor                 ecx, eax

        $sequence_9 = { 8bc2 33d2 c1e804 f7f1 }
            // n = 4, score = 600
            //   8bc2                 | mov                 eax, edx
            //   33d2                 | xor                 edx, edx
            //   c1e804               | shr                 eax, 4
            //   f7f1                 | div                 ecx

        $sequence_10 = { d1e9 03ca c1e907 2bc1 }
            // n = 4, score = 600
            //   d1e9                 | shr                 ecx, 1
            //   03ca                 | add                 ecx, edx
            //   c1e907               | shr                 ecx, 7
            //   2bc1                 | sub                 eax, ecx

        $sequence_11 = { d1e9 03ca 33d2 c1e908 }
            // n = 4, score = 600
            //   d1e9                 | shr                 ecx, 1
            //   03ca                 | add                 ecx, edx
            //   33d2                 | xor                 edx, edx
            //   c1e908               | shr                 ecx, 8

        $sequence_12 = { 5e 5d 0fb7c2 5b }
            // n = 4, score = 500
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   0fb7c2               | movzx               eax, dx
            //   5b                   | pop                 ebx

        $sequence_13 = { 668b4c2410 5f 5e 5d 0fb7c1 5b }
            // n = 6, score = 500
            //   668b4c2410           | mov                 cx, word ptr [esp + 0x10]
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   0fb7c1               | movzx               eax, cx
            //   5b                   | pop                 ebx

        $sequence_14 = { 0fb6c1 0fb6ca 33d2 f7f1 }
            // n = 4, score = 500
            //   0fb6c1               | movzx               eax, cl
            //   0fb6ca               | movzx               ecx, dl
            //   33d2                 | xor                 edx, edx
            //   f7f1                 | div                 ecx

        $sequence_15 = { 0fb7c0 0fb7c9 33d2 f7f1 }
            // n = 4, score = 500
            //   0fb7c0               | movzx               eax, ax
            //   0fb7c9               | movzx               ecx, cx
            //   33d2                 | xor                 edx, edx
            //   f7f1                 | div                 ecx

        $sequence_16 = { 0fb6c0 0fb6c9 33d2 f7f1 }
            // n = 4, score = 500
            //   0fb6c0               | movzx               eax, al
            //   0fb6c9               | movzx               ecx, cl
            //   33d2                 | xor                 edx, edx
            //   f7f1                 | div                 ecx

        $sequence_17 = { 668b442410 5f 5e 5d 0fb7c0 5b }
            // n = 6, score = 500
            //   668b442410           | mov                 ax, word ptr [esp + 0x10]
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   0fb7c0               | movzx               eax, ax
            //   5b                   | pop                 ebx

    condition:
        7 of them and filesize < 434176
}