rule win_alreay_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.alreay."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.alreay"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b742450 2bc6 f7d8 1bc0 259adaffff 5f 5e }
            // n = 7, score = 200
            //   8b742450             | mov                 esi, dword ptr [esp + 0x50]
            //   2bc6                 | sub                 eax, esi
            //   f7d8                 | neg                 eax
            //   1bc0                 | sbb                 eax, eax
            //   259adaffff           | and                 eax, 0xffffda9a
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_1 = { 8d442414 45 52 50 892d???????? e8???????? 8bf0 }
            // n = 7, score = 200
            //   8d442414             | lea                 eax, [esp + 0x14]
            //   45                   | inc                 ebp
            //   52                   | push                edx
            //   50                   | push                eax
            //   892d????????         |                     
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax

        $sequence_2 = { c1e21c 89442420 8954241c 8bc3 8bd5 e8???????? 8b4c2420 }
            // n = 7, score = 200
            //   c1e21c               | shl                 edx, 0x1c
            //   89442420             | mov                 dword ptr [esp + 0x20], eax
            //   8954241c             | mov                 dword ptr [esp + 0x1c], edx
            //   8bc3                 | mov                 eax, ebx
            //   8bd5                 | mov                 edx, ebp
            //   e8????????           |                     
            //   8b4c2420             | mov                 ecx, dword ptr [esp + 0x20]

        $sequence_3 = { 8ac1 f6d0 8a543418 8a5c3448 22d0 22d9 0ad3 }
            // n = 7, score = 200
            //   8ac1                 | mov                 al, cl
            //   f6d0                 | not                 al
            //   8a543418             | mov                 dl, byte ptr [esp + esi + 0x18]
            //   8a5c3448             | mov                 bl, byte ptr [esp + esi + 0x48]
            //   22d0                 | and                 dl, al
            //   22d9                 | and                 bl, cl
            //   0ad3                 | or                  dl, bl

        $sequence_4 = { 89742424 7fa9 5f 5e 5d b801000000 5b }
            // n = 7, score = 200
            //   89742424             | mov                 dword ptr [esp + 0x24], esi
            //   7fa9                 | jg                  0xffffffab
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   b801000000           | mov                 eax, 1
            //   5b                   | pop                 ebx

        $sequence_5 = { eb31 0fbf942454010000 8d442434 52 8d4c2414 50 8d542420 }
            // n = 7, score = 200
            //   eb31                 | jmp                 0x33
            //   0fbf942454010000     | movsx               edx, word ptr [esp + 0x154]
            //   8d442434             | lea                 eax, [esp + 0x34]
            //   52                   | push                edx
            //   8d4c2414             | lea                 ecx, [esp + 0x14]
            //   50                   | push                eax
            //   8d542420             | lea                 edx, [esp + 0x20]

        $sequence_6 = { 894e0c 8901 8b4c241c 8b460c 51 56 895804 }
            // n = 7, score = 200
            //   894e0c               | mov                 dword ptr [esi + 0xc], ecx
            //   8901                 | mov                 dword ptr [ecx], eax
            //   8b4c241c             | mov                 ecx, dword ptr [esp + 0x1c]
            //   8b460c               | mov                 eax, dword ptr [esi + 0xc]
            //   51                   | push                ecx
            //   56                   | push                esi
            //   895804               | mov                 dword ptr [eax + 4], ebx

        $sequence_7 = { 33c3 8b5c2424 03dd 03c3 8b5c2414 8dac03d6c162ca 8b442464 }
            // n = 7, score = 200
            //   33c3                 | xor                 eax, ebx
            //   8b5c2424             | mov                 ebx, dword ptr [esp + 0x24]
            //   03dd                 | add                 ebx, ebp
            //   03c3                 | add                 eax, ebx
            //   8b5c2414             | mov                 ebx, dword ptr [esp + 0x14]
            //   8dac03d6c162ca       | lea                 ebp, [ebx + eax - 0x359d3e2a]
            //   8b442464             | mov                 eax, dword ptr [esp + 0x64]

        $sequence_8 = { 8b8f98000000 89af90000000 83c901 899f94000000 898f98000000 8b879c000000 89879c000000 }
            // n = 7, score = 200
            //   8b8f98000000         | mov                 ecx, dword ptr [edi + 0x98]
            //   89af90000000         | mov                 dword ptr [edi + 0x90], ebp
            //   83c901               | or                  ecx, 1
            //   899f94000000         | mov                 dword ptr [edi + 0x94], ebx
            //   898f98000000         | mov                 dword ptr [edi + 0x98], ecx
            //   8b879c000000         | mov                 eax, dword ptr [edi + 0x9c]
            //   89879c000000         | mov                 dword ptr [edi + 0x9c], eax

        $sequence_9 = { 3d2c010000 7d1f 8d8664860000 50 e8???????? 8bd8 83c404 }
            // n = 7, score = 200
            //   3d2c010000           | cmp                 eax, 0x12c
            //   7d1f                 | jge                 0x21
            //   8d8664860000         | lea                 eax, [esi + 0x8664]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8bd8                 | mov                 ebx, eax
            //   83c404               | add                 esp, 4

    condition:
        7 of them and filesize < 1867776
}