rule win_anchormtea_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.anchormtea."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.anchormtea"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e9???????? f7d8 1bc0 83e002 }
            // n = 4, score = 200
            //   e9????????           |                     
            //   f7d8                 | neg                 eax
            //   1bc0                 | sbb                 eax, eax
            //   83e002               | and                 eax, 2

        $sequence_1 = { 83c40c 6808020000 6a40 ffd6 }
            // n = 4, score = 100
            //   83c40c               | mov                 dword ptr [ebx], ecx
            //   6808020000           | dec                 eax
            //   6a40                 | lea                 ecx, [eax + 8]
            //   ffd6                 | neg                 eax

        $sequence_2 = { bb01000000 8910 eb02 33db 85f6 }
            // n = 5, score = 100
            //   bb01000000           | push                edi
            //   8910                 | push                eax
            //   eb02                 | outsd               dx, dword ptr [esi]
            //   33db                 | dec                 ebx
            //   85f6                 | add                 byte ptr [eax], dl

        $sequence_3 = { 7512 488d056aaf0100 483bc8 7406 e8???????? }
            // n = 5, score = 100
            //   7512                 | jne                 0x14
            //   488d056aaf0100       | dec                 eax
            //   483bc8               | lea                 eax, [0x1af6a]
            //   7406                 | dec                 eax
            //   e8????????           |                     

        $sequence_4 = { 8b4508 57 8945d0 8d45c8 57 50 }
            // n = 6, score = 100
            //   8b4508               | mov                 esi, dword ptr [esp + 0x920]
            //   57                   | dec                 eax
            //   8945d0               | mov                 ebp, dword ptr [esp + 0x918]
            //   8d45c8               | inc                 ecx
            //   57                   | cmp                 dword ptr [esi + 0x24], edi
            //   50                   | jbe                 0x1f4

        $sequence_5 = { c68524f7ffff00 8d8d98f7ffff ffb524f7ffff 52 }
            // n = 4, score = 100
            //   c68524f7ffff00       | xorps               xmm0, xmm0
            //   8d8d98f7ffff         | dec                 eax
            //   ffb524f7ffff         | lea                 edx, [ebx + 8]
            //   52                   | dec                 eax

        $sequence_6 = { 41397e24 0f86ee010000 6666660f1f840000000000 4d8bc5 33d2 }
            // n = 5, score = 100
            //   41397e24             | test                esi, esi
            //   0f86ee010000         | je                  0x21
            //   6666660f1f840000000000     | dec    eax
            //   4d8bc5               | mov                 ecx, edi
            //   33d2                 | dec                 esp

        $sequence_7 = { 488b4b48 4885c9 740a ff15???????? 48897b48 }
            // n = 5, score = 100
            //   488b4b48             | cmp                 ecx, eax
            //   4885c9               | je                  8
            //   740a                 | dec                 eax
            //   ff15????????         |                     
            //   48897b48             | mov                 ecx, dword ptr [ebx + 0x48]

        $sequence_8 = { 488bcb e8???????? 488bcb ff15???????? 4885f6 7419 }
            // n = 6, score = 100
            //   488bcb               | dec                 eax
            //   e8????????           |                     
            //   488bcb               | mov                 dword ptr [ebx + 0x48], edi
            //   ff15????????         |                     
            //   4885f6               | dec                 eax
            //   7419                 | lea                 ecx, [eax + 8]

        $sequence_9 = { 3bc1 0f44d9 85f6 7407 56 }
            // n = 5, score = 100
            //   3bc1                 | outsd               dx, dword ptr [esi]
            //   0f44d9               | dec                 ebx
            //   85f6                 | add                 byte ptr [eax], dl
            //   7407                 | mov                 byte ptr [ebp - 0x8dc], 0
            //   56                   | lea                 ecx, [ebp - 0x868]

        $sequence_10 = { 6f 4b 0010 6f 4b 0010 }
            // n = 6, score = 100
            //   6f                   | nop                 word ptr [eax + eax]
            //   4b                   | dec                 ebp
            //   0010                 | mov                 eax, ebp
            //   6f                   | xor                 edx, edx
            //   4b                   | dec                 eax
            //   0010                 | lea                 ecx, [0x21245]

        $sequence_11 = { 488d4808 488d15c2180200 e8???????? 85c0 }
            // n = 4, score = 100
            //   488d4808             | dec                 eax
            //   488d15c2180200       | test                ecx, ecx
            //   e8????????           |                     
            //   85c0                 | je                  0xf

        $sequence_12 = { b801000000 488bbc24f0080000 488bb42420090000 488bac2418090000 }
            // n = 4, score = 100
            //   b801000000           | mov                 ecx, ebx
            //   488bbc24f0080000     | dec                 eax
            //   488bb42420090000     | mov                 ecx, ebx
            //   488bac2418090000     | dec                 eax

        $sequence_13 = { 488bcf 4c8bc3 4c2bc7 6690 }
            // n = 4, score = 100
            //   488bcf               | dec                 eax
            //   4c8bc3               | lea                 edx, [0x218c2]
            //   4c2bc7               | test                eax, eax
            //   6690                 | dec                 eax

        $sequence_14 = { 898534ffffff 7202 8b12 8bc2 8d7002 660f1f440000 }
            // n = 6, score = 100
            //   898534ffffff         | sbb                 eax, eax
            //   7202                 | and                 eax, 2
            //   8b12                 | mov                 eax, dword ptr [ebp + 8]
            //   8bc2                 | push                edi
            //   8d7002               | mov                 dword ptr [ebp - 0x30], eax
            //   660f1f440000         | lea                 eax, [ebp - 0x38]

    condition:
        7 of them and filesize < 839680
}