rule win_anel_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.anel."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.anel"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33ff 8db50cffffff e8???????? 6a01 8db5f0feffff e8???????? 6a01 }
            // n = 7, score = 200
            //   33ff                 | xor                 edi, edi
            //   8db50cffffff         | lea                 esi, [ebp - 0xf4]
            //   e8????????           |                     
            //   6a01                 | push                1
            //   8db5f0feffff         | lea                 esi, [ebp - 0x110]
            //   e8????????           |                     
            //   6a01                 | push                1

        $sequence_1 = { 8b45d4 7303 8d45d4 8b4de4 50 8d852cffffff }
            // n = 6, score = 200
            //   8b45d4               | mov                 eax, dword ptr [ebp - 0x2c]
            //   7303                 | jae                 5
            //   8d45d4               | lea                 eax, [ebp - 0x2c]
            //   8b4de4               | mov                 ecx, dword ptr [ebp - 0x1c]
            //   50                   | push                eax
            //   8d852cffffff         | lea                 eax, [ebp - 0xd4]

        $sequence_2 = { 0394b8480c0000 8b4dfc 334844 335040 8bc1 335508 c1e818 }
            // n = 7, score = 200
            //   0394b8480c0000       | add                 edx, dword ptr [eax + edi*4 + 0xc48]
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   334844               | xor                 ecx, dword ptr [eax + 0x44]
            //   335040               | xor                 edx, dword ptr [eax + 0x40]
            //   8bc1                 | mov                 eax, ecx
            //   335508               | xor                 edx, dword ptr [ebp + 8]
            //   c1e818               | shr                 eax, 0x18

        $sequence_3 = { e8???????? 8bd8 8b8504ffffff c645fc0b e8???????? 33db 43 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   8bd8                 | mov                 ebx, eax
            //   8b8504ffffff         | mov                 eax, dword ptr [ebp - 0xfc]
            //   c645fc0b             | mov                 byte ptr [ebp - 4], 0xb
            //   e8????????           |                     
            //   33db                 | xor                 ebx, ebx
            //   43                   | inc                 ebx

        $sequence_4 = { 668945d6 6a69 58 6a6e 668945d8 58 6a67 }
            // n = 7, score = 200
            //   668945d6             | mov                 word ptr [ebp - 0x2a], ax
            //   6a69                 | push                0x69
            //   58                   | pop                 eax
            //   6a6e                 | push                0x6e
            //   668945d8             | mov                 word ptr [ebp - 0x28], ax
            //   58                   | pop                 eax
            //   6a67                 | push                0x67

        $sequence_5 = { ffb5606ffeff ffd6 85c0 75c0 8d85646ffeff 50 ff95506ffeff }
            // n = 7, score = 200
            //   ffb5606ffeff         | push                dword ptr [ebp - 0x190a0]
            //   ffd6                 | call                esi
            //   85c0                 | test                eax, eax
            //   75c0                 | jne                 0xffffffc2
            //   8d85646ffeff         | lea                 eax, [ebp - 0x1909c]
            //   50                   | push                eax
            //   ff95506ffeff         | call                dword ptr [ebp - 0x190b0]

        $sequence_6 = { 6a00 8bc6 e8???????? 84c0 7439 837e1408 7204 }
            // n = 7, score = 200
            //   6a00                 | push                0
            //   8bc6                 | mov                 eax, esi
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   7439                 | je                  0x3b
            //   837e1408             | cmp                 dword ptr [esi + 0x14], 8
            //   7204                 | jb                  6

        $sequence_7 = { c20800 68???????? e8???????? cc 6a50 b8???????? e8???????? }
            // n = 7, score = 200
            //   c20800               | ret                 8
            //   68????????           |                     
            //   e8????????           |                     
            //   cc                   | int3                
            //   6a50                 | push                0x50
            //   b8????????           |                     
            //   e8????????           |                     

        $sequence_8 = { 51 50 e8???????? 8b44244c 894604 }
            // n = 5, score = 200
            //   51                   | push                ecx
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b44244c             | mov                 eax, dword ptr [esp + 0x4c]
            //   894604               | mov                 dword ptr [esi + 4], eax

        $sequence_9 = { 0f8e89000000 8b7510 85f6 7e62 ff7514 8d45f8 57 }
            // n = 7, score = 200
            //   0f8e89000000         | jle                 0x8f
            //   8b7510               | mov                 esi, dword ptr [ebp + 0x10]
            //   85f6                 | test                esi, esi
            //   7e62                 | jle                 0x64
            //   ff7514               | push                dword ptr [ebp + 0x14]
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   57                   | push                edi

    condition:
        7 of them and filesize < 376832
}