rule win_aperetif_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.aperetif."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.aperetif"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ba???????? c1e803 8d0c40 0fb7c6 c1e803 03c8 03c9 }
            // n = 7, score = 100
            //   ba????????           |                     
            //   c1e803               | shr                 eax, 3
            //   8d0c40               | lea                 ecx, [eax + eax*2]
            //   0fb7c6               | movzx               eax, si
            //   c1e803               | shr                 eax, 3
            //   03c8                 | add                 ecx, eax
            //   03c9                 | add                 ecx, ecx

        $sequence_1 = { ff15???????? 8bf8 89be8c020000 85ff 750d ff15???????? 8bf0 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax
            //   89be8c020000         | mov                 dword ptr [esi + 0x28c], edi
            //   85ff                 | test                edi, edi
            //   750d                 | jne                 0xf
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax

        $sequence_2 = { ff15???????? 85c0 0f858d060000 ff15???????? 6a0f 68???????? 8d4d58 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f858d060000         | jne                 0x693
            //   ff15????????         |                     
            //   6a0f                 | push                0xf
            //   68????????           |                     
            //   8d4d58               | lea                 ecx, [ebp + 0x58]

        $sequence_3 = { e8???????? 83c410 894500 85c0 7536 681e010000 68???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   894500               | mov                 dword ptr [ebp], eax
            //   85c0                 | test                eax, eax
            //   7536                 | jne                 0x38
            //   681e010000           | push                0x11e
            //   68????????           |                     

        $sequence_4 = { e8???????? 83c408 85c0 0f8427010000 83fe06 7506 f6431018 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   85c0                 | test                eax, eax
            //   0f8427010000         | je                  0x12d
            //   83fe06               | cmp                 esi, 6
            //   7506                 | jne                 8
            //   f6431018             | test                byte ptr [ebx + 0x10], 0x18

        $sequence_5 = { f6044dda3d8a0001 740e 8b450c 8b00 8b8094000000 8a0401 0fb6c0 }
            // n = 7, score = 100
            //   f6044dda3d8a0001     | test                byte ptr [ecx*2 + 0x8a3dda], 1
            //   740e                 | je                  0x10
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   8b8094000000         | mov                 eax, dword ptr [eax + 0x94]
            //   8a0401               | mov                 al, byte ptr [ecx + eax]
            //   0fb6c0               | movzx               eax, al

        $sequence_6 = { dd5c2410 f20f10542410 f20f59c2 f20f5cc8 e9???????? 85ff 7466 }
            // n = 7, score = 100
            //   dd5c2410             | fstp                qword ptr [esp + 0x10]
            //   f20f10542410         | movsd               xmm2, qword ptr [esp + 0x10]
            //   f20f59c2             | mulsd               xmm0, xmm2
            //   f20f5cc8             | subsd               xmm1, xmm0
            //   e9????????           |                     
            //   85ff                 | test                edi, edi
            //   7466                 | je                  0x68

        $sequence_7 = { ff0481 8b8424bc000000 ff81000b0000 40 898424bc000000 3b8424b8000000 7512 }
            // n = 7, score = 100
            //   ff0481               | inc                 dword ptr [ecx + eax*4]
            //   8b8424bc000000       | mov                 eax, dword ptr [esp + 0xbc]
            //   ff81000b0000         | inc                 dword ptr [ecx + 0xb00]
            //   40                   | inc                 eax
            //   898424bc000000       | mov                 dword ptr [esp + 0xbc], eax
            //   3b8424b8000000       | cmp                 eax, dword ptr [esp + 0xb8]
            //   7512                 | jne                 0x14

        $sequence_8 = { 8b33 85f6 0f8482000000 57 8b7b04 897dfc 3bf7 }
            // n = 7, score = 100
            //   8b33                 | mov                 esi, dword ptr [ebx]
            //   85f6                 | test                esi, esi
            //   0f8482000000         | je                  0x88
            //   57                   | push                edi
            //   8b7b04               | mov                 edi, dword ptr [ebx + 4]
            //   897dfc               | mov                 dword ptr [ebp - 4], edi
            //   3bf7                 | cmp                 esi, edi

        $sequence_9 = { ff742448 ff742424 ff742448 53 e8???????? 83c414 85c0 }
            // n = 7, score = 100
            //   ff742448             | push                dword ptr [esp + 0x48]
            //   ff742424             | push                dword ptr [esp + 0x24]
            //   ff742448             | push                dword ptr [esp + 0x48]
            //   53                   | push                ebx
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   85c0                 | test                eax, eax

    condition:
        7 of them and filesize < 10500096
}