rule win_ariabody_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.ariabody."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ariabody"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 2bd1 8a01 84c0 7406 3ac3 7402 }
            // n = 6, score = 300
            //   2bd1                 | sub                 edx, ecx
            //   8a01                 | mov                 al, byte ptr [ecx]
            //   84c0                 | test                al, al
            //   7406                 | je                  8
            //   3ac3                 | cmp                 al, bl
            //   7402                 | je                  4

        $sequence_1 = { 8d55fc 03f9 e8???????? 59 }
            // n = 4, score = 300
            //   8d55fc               | lea                 edx, [ebp - 4]
            //   03f9                 | add                 edi, ecx
            //   e8????????           |                     
            //   59                   | pop                 ecx

        $sequence_2 = { eb13 8b16 8bcf e8???????? }
            // n = 4, score = 300
            //   eb13                 | jmp                 0x15
            //   8b16                 | mov                 edx, dword ptr [esi]
            //   8bcf                 | mov                 ecx, edi
            //   e8????????           |                     

        $sequence_3 = { 8bcf 0fb6c0 50 ff75fc }
            // n = 4, score = 300
            //   8bcf                 | mov                 ecx, edi
            //   0fb6c0               | movzx               eax, al
            //   50                   | push                eax
            //   ff75fc               | push                dword ptr [ebp - 4]

        $sequence_4 = { 50 ff5204 8b1e 8bd0 }
            // n = 4, score = 300
            //   50                   | push                eax
            //   ff5204               | call                dword ptr [edx + 4]
            //   8b1e                 | mov                 ebx, dword ptr [esi]
            //   8bd0                 | mov                 edx, eax

        $sequence_5 = { 50 8d040a 50 57 }
            // n = 4, score = 300
            //   50                   | push                eax
            //   8d040a               | lea                 eax, [edx + ecx]
            //   50                   | push                eax
            //   57                   | push                edi

        $sequence_6 = { 8d0c30 ffd1 8bc6 5f }
            // n = 4, score = 300
            //   8d0c30               | lea                 ecx, [eax + esi]
            //   ffd1                 | call                ecx
            //   8bc6                 | mov                 eax, esi
            //   5f                   | pop                 edi

        $sequence_7 = { 83ec50 53 57 8bd9 }
            // n = 4, score = 300
            //   83ec50               | sub                 esp, 0x50
            //   53                   | push                ebx
            //   57                   | push                edi
            //   8bd9                 | mov                 ebx, ecx

        $sequence_8 = { 4889e9 8984247a020000 c784248e02000032303000 c7842460020000434f4e4e }
            // n = 4, score = 100
            //   4889e9               | mov                 ecx, ebp
            //   8984247a020000       | dec                 eax
            //   c784248e02000032303000     | lea    edx, [esp + 0x220]
            //   c7842460020000434f4e4e     | call    dword ptr [esi + 0x1b8]

        $sequence_9 = { 4c03f7 4c8b4c3d00 4c8d6c2f08 4d85c9 7444 48bd0000000000000080 4985e9 }
            // n = 7, score = 100
            //   4c03f7               | dec                 esp
            //   4c8b4c3d00           | add                 esi, edi
            //   4c8d6c2f08           | dec                 esp
            //   4d85c9               | mov                 ecx, dword ptr [ebp + edi]
            //   7444                 | dec                 esp
            //   48bd0000000000000080     | lea    ebp, [edi + ebp + 8]
            //   4985e9               | dec                 ebp

        $sequence_10 = { ff15???????? 488d15e5780000 483305???????? 488bcb 488905???????? ff15???????? 488d15df780000 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   488d15e5780000       | lea                 edx, [eax + eax]
            //   483305????????       |                     
            //   488bcb               | mov                 dword ptr [ebp - 0x24], edx
            //   488905????????       |                     
            //   ff15????????         |                     
            //   488d15df780000       | jmp                 0x4f

        $sequence_11 = { 488b81f0000000 488bd9 4885c0 7479 488d0ddad00000 483bc1 }
            // n = 6, score = 100
            //   488b81f0000000       | mov                 edi, edx
            //   488bd9               | dec                 eax
            //   4885c0               | mov                 esi, ecx
            //   7479                 | dec                 ebp
            //   488d0ddad00000       | mov                 esp, eax
            //   483bc1               | xor                 edx, edx

        $sequence_12 = { e9???????? 8b45dc 8d1400 8955dc eb47 488d0d648bffff 4c8d4ddc }
            // n = 7, score = 100
            //   e9????????           |                     
            //   8b45dc               | test                ecx, ecx
            //   8d1400               | je                  0x49
            //   8955dc               | dec                 eax
            //   eb47                 | mov                 ebp, 0
            //   488d0d648bffff       | add                 byte ptr [eax], al
            //   4c8d4ddc             | mov                 eax, dword ptr [ebp - 0x24]

        $sequence_13 = { 4881eca8020000 4889d7 4889ce 4d89c4 33d2 41b800010000 33c0 }
            // n = 7, score = 100
            //   4881eca8020000       | dec                 eax
            //   4889d7               | lea                 ecx, [0xffff8b64]
            //   4889ce               | dec                 esp
            //   4d89c4               | lea                 ecx, [ebp - 0x24]
            //   33d2                 | dec                 eax
            //   41b800010000         | lea                 edx, [0x78e5]
            //   33c0                 | dec                 eax

        $sequence_14 = { 448850d2 448850d3 448850d4 448850d5 448850d6 448858d7 c740d80b010000 }
            // n = 7, score = 100
            //   448850d2             | inc                 ecx
            //   448850d3             | mov                 eax, 0x100
            //   448850d4             | xor                 eax, eax
            //   448850d5             | dec                 eax
            //   448850d6             | lea                 edx, [esp + 0x292]
            //   448858d7             | call                dword ptr [esi + 0x1b8]
            //   c740d80b010000       | dec                 eax

        $sequence_15 = { 488d942492020000 ff96b8010000 4889e9 488d942420020000 ff96b8010000 4889e9 }
            // n = 6, score = 100
            //   488d942492020000     | mov                 ecx, ebx
            //   ff96b8010000         | dec                 eax
            //   4889e9               | lea                 edx, [0x78df]
            //   488d942420020000     | dec                 eax
            //   ff96b8010000         | sub                 esp, 0x2a8
            //   4889e9               | dec                 eax

    condition:
        7 of them and filesize < 253952
}