rule win_auriga_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.auriga."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.auriga"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 68???????? 56 e8???????? 57 8d85f0f9ffff 50 }
            // n = 6, score = 100
            //   68????????           |                     
            //   56                   | push                esi
            //   e8????????           |                     
            //   57                   | push                edi
            //   8d85f0f9ffff         | lea                 eax, [ebp - 0x610]
            //   50                   | push                eax

        $sequence_1 = { 8b35???????? ffd6 8945f4 8b45d4 83c002 }
            // n = 5, score = 100
            //   8b35????????         |                     
            //   ffd6                 | call                esi
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   8b45d4               | mov                 eax, dword ptr [ebp - 0x2c]
            //   83c002               | add                 eax, 2

        $sequence_2 = { 7410 6681f96c68 7409 0fb74802 ff3488 }
            // n = 5, score = 100
            //   7410                 | je                  0x12
            //   6681f96c68           | cmp                 cx, 0x686c
            //   7409                 | je                  0xb
            //   0fb74802             | movzx               ecx, word ptr [eax + 2]
            //   ff3488               | push                dword ptr [eax + ecx*4]

        $sequence_3 = { 40 40 663bcf 75ea }
            // n = 4, score = 100
            //   40                   | inc                 eax
            //   40                   | inc                 eax
            //   663bcf               | cmp                 cx, di
            //   75ea                 | jne                 0xffffffec

        $sequence_4 = { ff15???????? 85c0 7c1e a1???????? }
            // n = 4, score = 100
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7c1e                 | jl                  0x20
            //   a1????????           |                     

        $sequence_5 = { 7518 ffb5f8fbffff 8b35???????? ffd6 ffb5f4fbffff ffd6 33c0 }
            // n = 7, score = 100
            //   7518                 | jne                 0x1a
            //   ffb5f8fbffff         | push                dword ptr [ebp - 0x408]
            //   8b35????????         |                     
            //   ffd6                 | call                esi
            //   ffb5f4fbffff         | push                dword ptr [ebp - 0x40c]
            //   ffd6                 | call                esi
            //   33c0                 | xor                 eax, eax

        $sequence_6 = { 8b0d???????? 03c1 3900 74f0 8b15???????? 56 }
            // n = 6, score = 100
            //   8b0d????????         |                     
            //   03c1                 | add                 eax, ecx
            //   3900                 | cmp                 dword ptr [eax], eax
            //   74f0                 | je                  0xfffffff2
            //   8b15????????         |                     
            //   56                   | push                esi

        $sequence_7 = { 8b5a1c 03dd 8b048b 03c5 8944241c 61 }
            // n = 6, score = 100
            //   8b5a1c               | mov                 ebx, dword ptr [edx + 0x1c]
            //   03dd                 | add                 ebx, ebp
            //   8b048b               | mov                 eax, dword ptr [ebx + ecx*4]
            //   03c5                 | add                 eax, ebp
            //   8944241c             | mov                 dword ptr [esp + 0x1c], eax
            //   61                   | popal               

        $sequence_8 = { 0f8ce7010000 8d85e8f9ffff 50 8d85e0f9ffff }
            // n = 4, score = 100
            //   0f8ce7010000         | jl                  0x1ed
            //   8d85e8f9ffff         | lea                 eax, [ebp - 0x618]
            //   50                   | push                eax
            //   8d85e0f9ffff         | lea                 eax, [ebp - 0x620]

        $sequence_9 = { 33c0 8945e4 8945f0 8945f4 8d45e0 }
            // n = 5, score = 100
            //   33c0                 | xor                 eax, eax
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   8d45e0               | lea                 eax, [ebp - 0x20]

    condition:
        7 of them and filesize < 75776
}