rule win_aytoke_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.aytoke."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.aytoke"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 75e9 e9???????? 33c0 8bff 0fb78874374100 66898c05fcfdffff }
            // n = 6, score = 200
            //   75e9                 | jne                 0xffffffeb
            //   e9????????           |                     
            //   33c0                 | xor                 eax, eax
            //   8bff                 | mov                 edi, edi
            //   0fb78874374100       | movzx               ecx, word ptr [eax + 0x413774]
            //   66898c05fcfdffff     | mov                 word ptr [ebp + eax - 0x204], cx

        $sequence_1 = { 83feff 751a ff15???????? 50 68???????? e8???????? }
            // n = 6, score = 200
            //   83feff               | cmp                 esi, -1
            //   751a                 | jne                 0x1c
            //   ff15????????         |                     
            //   50                   | push                eax
            //   68????????           |                     
            //   e8????????           |                     

        $sequence_2 = { 83c204 83c404 3bd6 7c1b 90 }
            // n = 5, score = 200
            //   83c204               | add                 edx, 4
            //   83c404               | add                 esp, 4
            //   3bd6                 | cmp                 edx, esi
            //   7c1b                 | jl                  0x1d
            //   90                   | nop                 

        $sequence_3 = { e9???????? 33c0 8bff 0fb788343a4100 66898c05fcfdffff 83c002 }
            // n = 6, score = 200
            //   e9????????           |                     
            //   33c0                 | xor                 eax, eax
            //   8bff                 | mov                 edi, edi
            //   0fb788343a4100       | movzx               ecx, word ptr [eax + 0x413a34]
            //   66898c05fcfdffff     | mov                 word ptr [ebp + eax - 0x204], cx
            //   83c002               | add                 eax, 2

        $sequence_4 = { 8d0cbd00c44100 8901 8305????????20 8b11 }
            // n = 4, score = 200
            //   8d0cbd00c44100       | lea                 ecx, [edi*4 + 0x41c400]
            //   8901                 | mov                 dword ptr [ecx], eax
            //   8305????????20       |                     
            //   8b11                 | mov                 edx, dword ptr [ecx]

        $sequence_5 = { c1e106 030c9d00c44100 eb02 8bca f641247f 7525 }
            // n = 6, score = 200
            //   c1e106               | shl                 ecx, 6
            //   030c9d00c44100       | add                 ecx, dword ptr [ebx*4 + 0x41c400]
            //   eb02                 | jmp                 4
            //   8bca                 | mov                 ecx, edx
            //   f641247f             | test                byte ptr [ecx + 0x24], 0x7f
            //   7525                 | jne                 0x27

        $sequence_6 = { be???????? 8d7de0 f3a5 50 }
            // n = 4, score = 200
            //   be????????           |                     
            //   8d7de0               | lea                 edi, [ebp - 0x20]
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   50                   | push                eax

        $sequence_7 = { b32a 3bc8 7c0e 389850744100 7501 42 40 }
            // n = 7, score = 200
            //   b32a                 | mov                 bl, 0x2a
            //   3bc8                 | cmp                 ecx, eax
            //   7c0e                 | jl                  0x10
            //   389850744100         | cmp                 byte ptr [eax + 0x417450], bl
            //   7501                 | jne                 3
            //   42                   | inc                 edx
            //   40                   | inc                 eax

        $sequence_8 = { e8???????? 0fb60d???????? 51 8d55d4 52 68???????? 8d85f8f9ffff }
            // n = 7, score = 200
            //   e8????????           |                     
            //   0fb60d????????       |                     
            //   51                   | push                ecx
            //   8d55d4               | lea                 edx, [ebp - 0x2c]
            //   52                   | push                edx
            //   68????????           |                     
            //   8d85f8f9ffff         | lea                 eax, [ebp - 0x608]

        $sequence_9 = { 46 eb18 b801000000 3bc8 7c0f 3b1485989c4100 7501 }
            // n = 7, score = 200
            //   46                   | inc                 esi
            //   eb18                 | jmp                 0x1a
            //   b801000000           | mov                 eax, 1
            //   3bc8                 | cmp                 ecx, eax
            //   7c0f                 | jl                  0x11
            //   3b1485989c4100       | cmp                 edx, dword ptr [eax*4 + 0x419c98]
            //   7501                 | jne                 3

    condition:
        7 of them and filesize < 425984
}