rule win_balkan_door_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.balkan_door."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.balkan_door"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 56 ffd7 5e 32c0 5f c3 32c0 }
            // n = 7, score = 600
            //   56                   | push                esi
            //   ffd7                 | call                edi
            //   5e                   | pop                 esi
            //   32c0                 | xor                 al, al
            //   5f                   | pop                 edi
            //   c3                   | ret                 
            //   32c0                 | xor                 al, al

        $sequence_1 = { c785ccfdffff00000000 50 56 c785d0fdffff2c020000 ff15???????? }
            // n = 5, score = 600
            //   c785ccfdffff00000000     | mov    dword ptr [ebp - 0x234], 0
            //   50                   | push                eax
            //   56                   | push                esi
            //   c785d0fdffff2c020000     | mov    dword ptr [ebp - 0x230], 0x22c
            //   ff15????????         |                     

        $sequence_2 = { ff15???????? 8bf8 89bd3cefffff 85ff }
            // n = 4, score = 600
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax
            //   89bd3cefffff         | mov                 dword ptr [ebp - 0x10c4], edi
            //   85ff                 | test                edi, edi

        $sequence_3 = { 8be5 5d c3 8d85d0fdffff c785ccfdffff00000000 50 56 }
            // n = 7, score = 600
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   8d85d0fdffff         | lea                 eax, [ebp - 0x230]
            //   c785ccfdffff00000000     | mov    dword ptr [ebp - 0x234], 0
            //   50                   | push                eax
            //   56                   | push                esi

        $sequence_4 = { 85f6 740b 6a00 6a00 56 ff15???????? 57 }
            // n = 7, score = 600
            //   85f6                 | test                esi, esi
            //   740b                 | je                  0xd
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   56                   | push                esi
            //   ff15????????         |                     
            //   57                   | push                edi

        $sequence_5 = { 6a01 6a02 6a10 6a04 68???????? }
            // n = 5, score = 600
            //   6a01                 | push                1
            //   6a02                 | push                2
            //   6a10                 | push                0x10
            //   6a04                 | push                4
            //   68????????           |                     

        $sequence_6 = { 6a00 56 ff15???????? 57 8b3d???????? ffd7 85f6 }
            // n = 7, score = 600
            //   6a00                 | push                0
            //   56                   | push                esi
            //   ff15????????         |                     
            //   57                   | push                edi
            //   8b3d????????         |                     
            //   ffd7                 | call                edi
            //   85f6                 | test                esi, esi

        $sequence_7 = { c3 8d85d0fdffff c785ccfdffff00000000 50 56 }
            // n = 5, score = 600
            //   c3                   | ret                 
            //   8d85d0fdffff         | lea                 eax, [ebp - 0x230]
            //   c785ccfdffff00000000     | mov    dword ptr [ebp - 0x234], 0
            //   50                   | push                eax
            //   56                   | push                esi

        $sequence_8 = { ffd7 6a00 ff35???????? ffd3 85c0 }
            // n = 5, score = 600
            //   ffd7                 | call                edi
            //   6a00                 | push                0
            //   ff35????????         |                     
            //   ffd3                 | call                ebx
            //   85c0                 | test                eax, eax

        $sequence_9 = { 52 50 ff15???????? 8bf8 89bd3cefffff 85ff }
            // n = 6, score = 600
            //   52                   | push                edx
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax
            //   89bd3cefffff         | mov                 dword ptr [ebp - 0x10c4], edi
            //   85ff                 | test                edi, edi

    condition:
        7 of them and filesize < 352256
}