rule win_bamital_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.bamital."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bamital"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6800040000 e8???????? 8045f301 ff45fc }
            // n = 4, score = 300
            //   6800040000           | push                0x400
            //   e8????????           |                     
            //   8045f301             | add                 byte ptr [ebp - 0xd], 1
            //   ff45fc               | inc                 dword ptr [ebp - 4]

        $sequence_1 = { 803820 7516 83c101 83f901 7504 8bd0 }
            // n = 6, score = 300
            //   803820               | cmp                 byte ptr [eax], 0x20
            //   7516                 | jne                 0x18
            //   83c101               | add                 ecx, 1
            //   83f901               | cmp                 ecx, 1
            //   7504                 | jne                 6
            //   8bd0                 | mov                 edx, eax

        $sequence_2 = { 2c1f b47e 02e0 80ec19 }
            // n = 4, score = 300
            //   2c1f                 | sub                 al, 0x1f
            //   b47e                 | mov                 ah, 0x7e
            //   02e0                 | add                 ah, al
            //   80ec19               | sub                 ah, 0x19

        $sequence_3 = { ff75f8 ff7508 e8???????? e8???????? 8b7dfc }
            // n = 5, score = 300
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     
            //   e8????????           |                     
            //   8b7dfc               | mov                 edi, dword ptr [ebp - 4]

        $sequence_4 = { 52 8b5508 b800000000 803a00 7408 }
            // n = 5, score = 300
            //   52                   | push                edx
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   b800000000           | mov                 eax, 0
            //   803a00               | cmp                 byte ptr [edx], 0
            //   7408                 | je                  0xa

        $sequence_5 = { 837dd800 7505 e9???????? 837df000 }
            // n = 4, score = 300
            //   837dd800             | cmp                 dword ptr [ebp - 0x28], 0
            //   7505                 | jne                 7
            //   e9????????           |                     
            //   837df000             | cmp                 dword ptr [ebp - 0x10], 0

        $sequence_6 = { 8945f8 8b4df8 2b4d08 51 }
            // n = 4, score = 300
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   2b4d08               | sub                 ecx, dword ptr [ebp + 8]
            //   51                   | push                ecx

        $sequence_7 = { 8bec 56 50 8b550c 8b7508 }
            // n = 5, score = 300
            //   8bec                 | mov                 ebp, esp
            //   56                   | push                esi
            //   50                   | push                eax
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]

        $sequence_8 = { 8bd0 eb0a 83f904 7505 c60000 eb05 83c001 }
            // n = 7, score = 300
            //   8bd0                 | mov                 edx, eax
            //   eb0a                 | jmp                 0xc
            //   83f904               | cmp                 ecx, 4
            //   7505                 | jne                 7
            //   c60000               | mov                 byte ptr [eax], 0
            //   eb05                 | jmp                 7
            //   83c001               | add                 eax, 1

        $sequence_9 = { 83f901 7504 8bd0 eb0a 83f904 7505 c60000 }
            // n = 7, score = 300
            //   83f901               | cmp                 ecx, 1
            //   7504                 | jne                 6
            //   8bd0                 | mov                 edx, eax
            //   eb0a                 | jmp                 0xc
            //   83f904               | cmp                 ecx, 4
            //   7505                 | jne                 7
            //   c60000               | mov                 byte ptr [eax], 0

    condition:
        7 of them and filesize < 90112
}