rule win_banatrix_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.banatrix."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.banatrix"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c744240c04000000 c744240800100000 03420c 8955c4 890424 }
            // n = 5, score = 200
            //   c744240c04000000     | mov                 dword ptr [esp + 0xc], 4
            //   c744240800100000     | mov                 dword ptr [esp + 8], 0x1000
            //   03420c               | add                 eax, dword ptr [edx + 0xc]
            //   8955c4               | mov                 dword ptr [ebp - 0x3c], edx
            //   890424               | mov                 dword ptr [esp], eax

        $sequence_1 = { 56 56 7416 8b03 c745d000000000 0fb75014 8d741018 }
            // n = 7, score = 200
            //   56                   | push                esi
            //   56                   | push                esi
            //   7416                 | je                  0x18
            //   8b03                 | mov                 eax, dword ptr [ebx]
            //   c745d000000000       | mov                 dword ptr [ebp - 0x30], 0
            //   0fb75014             | movzx               edx, word ptr [eax + 0x14]
            //   8d741018             | lea                 esi, [eax + edx + 0x18]

        $sequence_2 = { c704245a040000 e9???????? c7431001000000 89d8 eb02 }
            // n = 5, score = 200
            //   c704245a040000       | mov                 dword ptr [esp], 0x45a
            //   e9????????           |                     
            //   c7431001000000       | mov                 dword ptr [ebx + 0x10], 1
            //   89d8                 | mov                 eax, ebx
            //   eb02                 | jmp                 4

        $sequence_3 = { e8???????? 85c0 7505 c60300 eb56 8b5704 }
            // n = 6, score = 200
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7505                 | jne                 7
            //   c60300               | mov                 byte ptr [ebx], 0
            //   eb56                 | jmp                 0x58
            //   8b5704               | mov                 edx, dword ptr [edi + 4]

        $sequence_4 = { e8???????? 8b4304 85c0 741b c744240800800000 c744240400000000 890424 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   8b4304               | mov                 eax, dword ptr [ebx + 4]
            //   85c0                 | test                eax, eax
            //   741b                 | je                  0x1d
            //   c744240800800000     | mov                 dword ptr [esp + 8], 0x8000
            //   c744240400000000     | mov                 dword ptr [esp + 4], 0
            //   890424               | mov                 dword ptr [esp], eax

        $sequence_5 = { eb20 8b7514 39f0 7306 c6040300 }
            // n = 5, score = 200
            //   eb20                 | jmp                 0x22
            //   8b7514               | mov                 esi, dword ptr [ebp + 0x14]
            //   39f0                 | cmp                 eax, esi
            //   7306                 | jae                 8
            //   c6040300             | mov                 byte ptr [ebx + eax], 0

        $sequence_6 = { 83c628 8b13 0fb74206 3945d0 7cc8 eb6d 89c7 }
            // n = 7, score = 200
            //   83c628               | add                 esi, 0x28
            //   8b13                 | mov                 edx, dword ptr [ebx]
            //   0fb74206             | movzx               eax, word ptr [edx + 6]
            //   3945d0               | cmp                 dword ptr [ebp - 0x30], eax
            //   7cc8                 | jl                  0xffffffca
            //   eb6d                 | jmp                 0x6f
            //   89c7                 | mov                 edi, eax

        $sequence_7 = { e8???????? 89c6 8b45e4 0fb7f6 890424 }
            // n = 5, score = 200
            //   e8????????           |                     
            //   89c6                 | mov                 esi, eax
            //   8b45e4               | mov                 eax, dword ptr [ebp - 0x1c]
            //   0fb7f6               | movzx               esi, si
            //   890424               | mov                 dword ptr [esp], eax

        $sequence_8 = { 8b5d08 85db 0f849c000000 837b1000 7429 8b13 }
            // n = 6, score = 200
            //   8b5d08               | mov                 ebx, dword ptr [ebp + 8]
            //   85db                 | test                ebx, ebx
            //   0f849c000000         | je                  0xa2
            //   837b1000             | cmp                 dword ptr [ebx + 0x10], 0
            //   7429                 | je                  0x2b
            //   8b13                 | mov                 edx, dword ptr [ebx]

        $sequence_9 = { 8b450c 5d 8b4004 c3 55 89e5 }
            // n = 6, score = 200
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   5d                   | pop                 ebp
            //   8b4004               | mov                 eax, dword ptr [eax + 4]
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   89e5                 | mov                 ebp, esp

    condition:
        7 of them and filesize < 180224
}