rule win_bee_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.bee."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bee"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b450c 2bc6 50 03fe 57 8d4c2434 899c2498000000 }
            // n = 7, score = 100
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   2bc6                 | sub                 eax, esi
            //   50                   | push                eax
            //   03fe                 | add                 edi, esi
            //   57                   | push                edi
            //   8d4c2434             | lea                 ecx, [esp + 0x34]
            //   899c2498000000       | mov                 dword ptr [esp + 0x98], ebx

        $sequence_1 = { e8???????? 68dc050000 ffd6 8b842488000000 39ac249c000000 7307 8d842488000000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   68dc050000           | push                0x5dc
            //   ffd6                 | call                esi
            //   8b842488000000       | mov                 eax, dword ptr [esp + 0x88]
            //   39ac249c000000       | cmp                 dword ptr [esp + 0x9c], ebp
            //   7307                 | jae                 9
            //   8d842488000000       | lea                 eax, [esp + 0x88]

        $sequence_2 = { e8???????? 83c404 837e5410 720c 8b4e40 51 e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   837e5410             | cmp                 dword ptr [esi + 0x54], 0x10
            //   720c                 | jb                  0xe
            //   8b4e40               | mov                 ecx, dword ptr [esi + 0x40]
            //   51                   | push                ecx
            //   e8????????           |                     

        $sequence_3 = { c700???????? 894804 894808 83c00c 50 e8???????? }
            // n = 6, score = 100
            //   c700????????         |                     
            //   894804               | mov                 dword ptr [eax + 4], ecx
            //   894808               | mov                 dword ptr [eax + 8], ecx
            //   83c00c               | add                 eax, 0xc
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_4 = { 7d10 668b4c4310 66890c4544504200 40 }
            // n = 4, score = 100
            //   7d10                 | jge                 0x12
            //   668b4c4310           | mov                 cx, word ptr [ebx + eax*2 + 0x10]
            //   66890c4544504200     | mov                 word ptr [eax*2 + 0x425044], cx
            //   40                   | inc                 eax

        $sequence_5 = { 0fb6510c 885004 8b5110 895008 0fb65114 }
            // n = 5, score = 100
            //   0fb6510c             | movzx               edx, byte ptr [ecx + 0xc]
            //   885004               | mov                 byte ptr [eax + 4], dl
            //   8b5110               | mov                 edx, dword ptr [ecx + 0x10]
            //   895008               | mov                 dword ptr [eax + 8], edx
            //   0fb65114             | movzx               edx, byte ptr [ecx + 0x14]

        $sequence_6 = { 50 c744242488130000 ff15???????? 8b1d???????? }
            // n = 4, score = 100
            //   50                   | push                eax
            //   c744242488130000     | mov                 dword ptr [esp + 0x24], 0x1388
            //   ff15????????         |                     
            //   8b1d????????         |                     

        $sequence_7 = { 50 57 ffd5 83f8ff 7508 ff15???????? f7d8 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   57                   | push                edi
            //   ffd5                 | call                ebp
            //   83f8ff               | cmp                 eax, -1
            //   7508                 | jne                 0xa
            //   ff15????????         |                     
            //   f7d8                 | neg                 eax

        $sequence_8 = { 8d1c8d00534200 8bf8 83e71f c1e706 8b0b 0fbe4c3904 83e101 }
            // n = 7, score = 100
            //   8d1c8d00534200       | lea                 ebx, [ecx*4 + 0x425300]
            //   8bf8                 | mov                 edi, eax
            //   83e71f               | and                 edi, 0x1f
            //   c1e706               | shl                 edi, 6
            //   8b0b                 | mov                 ecx, dword ptr [ebx]
            //   0fbe4c3904           | movsx               ecx, byte ptr [ecx + edi + 4]
            //   83e101               | and                 ecx, 1

        $sequence_9 = { 8bf8 eb02 33ff c744242cffffffff 897c2414 85ff }
            // n = 6, score = 100
            //   8bf8                 | mov                 edi, eax
            //   eb02                 | jmp                 4
            //   33ff                 | xor                 edi, edi
            //   c744242cffffffff     | mov                 dword ptr [esp + 0x2c], 0xffffffff
            //   897c2414             | mov                 dword ptr [esp + 0x14], edi
            //   85ff                 | test                edi, edi

    condition:
        7 of them and filesize < 394240
}