rule win_bistromath_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.bistromath."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bistromath"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 8bd8 85db 750a 8b45f8 c6400505 88580f }
            // n = 7, score = 400
            //   e8????????           |                     
            //   8bd8                 | mov                 ebx, eax
            //   85db                 | test                ebx, ebx
            //   750a                 | jne                 0xc
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   c6400505             | mov                 byte ptr [eax + 5], 5
            //   88580f               | mov                 byte ptr [eax + 0xf], bl

        $sequence_1 = { 8bcb e8???????? 8b8318020000 8a08 84c9 740b 80f93b }
            // n = 7, score = 400
            //   8bcb                 | mov                 ecx, ebx
            //   e8????????           |                     
            //   8b8318020000         | mov                 eax, dword ptr [ebx + 0x218]
            //   8a08                 | mov                 cl, byte ptr [eax]
            //   84c9                 | test                cl, cl
            //   740b                 | je                  0xd
            //   80f93b               | cmp                 cl, 0x3b

        $sequence_2 = { f30f7e44c748 660fd641f8 83ea01 75c0 8b7c2464 8b742470 eb07 }
            // n = 7, score = 400
            //   f30f7e44c748         | movq                xmm0, qword ptr [edi + eax*8 + 0x48]
            //   660fd641f8           | movq                qword ptr [ecx - 8], xmm0
            //   83ea01               | sub                 edx, 1
            //   75c0                 | jne                 0xffffffc2
            //   8b7c2464             | mov                 edi, dword ptr [esp + 0x64]
            //   8b742470             | mov                 esi, dword ptr [esp + 0x70]
            //   eb07                 | jmp                 9

        $sequence_3 = { 8b4e04 85c9 740b 8b461c 8d0480 c64481ef08 8b45a8 }
            // n = 7, score = 400
            //   8b4e04               | mov                 ecx, dword ptr [esi + 4]
            //   85c9                 | test                ecx, ecx
            //   740b                 | je                  0xd
            //   8b461c               | mov                 eax, dword ptr [esi + 0x1c]
            //   8d0480               | lea                 eax, [eax + eax*4]
            //   c64481ef08           | mov                 byte ptr [ecx + eax*4 - 0x11], 8
            //   8b45a8               | mov                 eax, dword ptr [ebp - 0x58]

        $sequence_4 = { e8???????? 85c0 0f84fb010000 e9???????? 0fb645fe 3bf0 0f852a010000 }
            // n = 7, score = 400
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f84fb010000         | je                  0x201
            //   e9????????           |                     
            //   0fb645fe             | movzx               eax, byte ptr [ebp - 2]
            //   3bf0                 | cmp                 esi, eax
            //   0f852a010000         | jne                 0x130

        $sequence_5 = { 8b97a0000000 8bcf e8???????? 8b879c000000 8b4df8 89b7a0000000 890c86 }
            // n = 7, score = 400
            //   8b97a0000000         | mov                 edx, dword ptr [edi + 0xa0]
            //   8bcf                 | mov                 ecx, edi
            //   e8????????           |                     
            //   8b879c000000         | mov                 eax, dword ptr [edi + 0x9c]
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   89b7a0000000         | mov                 dword ptr [edi + 0xa0], esi
            //   890c86               | mov                 dword ptr [esi + eax*4], ecx

        $sequence_6 = { ffd6 85c0 7407 bb01000000 eb18 a1???????? 85c0 }
            // n = 7, score = 400
            //   ffd6                 | call                esi
            //   85c0                 | test                eax, eax
            //   7407                 | je                  9
            //   bb01000000           | mov                 ebx, 1
            //   eb18                 | jmp                 0x1a
            //   a1????????           |                     
            //   85c0                 | test                eax, eax

        $sequence_7 = { ff15???????? 85c0 0f8504ffffff ffb57cf5ffff ff15???????? 8b4df8 5f }
            // n = 7, score = 400
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f8504ffffff         | jne                 0xffffff0a
            //   ffb57cf5ffff         | push                dword ptr [ebp - 0xa84]
            //   ff15????????         |                     
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   5f                   | pop                 edi

        $sequence_8 = { e9???????? 55 8bec 83ec08 56 8b713c 8b06 }
            // n = 7, score = 400
            //   e9????????           |                     
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83ec08               | sub                 esp, 8
            //   56                   | push                esi
            //   8b713c               | mov                 esi, dword ptr [ecx + 0x3c]
            //   8b06                 | mov                 eax, dword ptr [esi]

        $sequence_9 = { c7421000000000 e8???????? 85f6 746d 83bb0002000000 7435 3bb30c010000 }
            // n = 7, score = 400
            //   c7421000000000       | mov                 dword ptr [edx + 0x10], 0
            //   e8????????           |                     
            //   85f6                 | test                esi, esi
            //   746d                 | je                  0x6f
            //   83bb0002000000       | cmp                 dword ptr [ebx + 0x200], 0
            //   7435                 | je                  0x37
            //   3bb30c010000         | cmp                 esi, dword ptr [ebx + 0x10c]

    condition:
        7 of them and filesize < 33816576
}