rule win_bit_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.bit_rat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bit_rat"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 8b37 8bce 6a01 e8???????? 6a01 8bce }
            // n = 7, score = 200
            //   e8????????           |                     
            //   8b37                 | mov                 esi, dword ptr [edi]
            //   8bce                 | mov                 ecx, esi
            //   6a01                 | push                1
            //   e8????????           |                     
            //   6a01                 | push                1
            //   8bce                 | mov                 ecx, esi

        $sequence_1 = { e8???????? 6a30 56 e8???????? 83c408 c645fc07 8b4578 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   6a30                 | push                0x30
            //   56                   | push                esi
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   c645fc07             | mov                 byte ptr [ebp - 4], 7
            //   8b4578               | mov                 eax, dword ptr [ebp + 0x78]

        $sequence_2 = { eb09 6a00 6a00 68a7000000 68a4000000 6a22 e8???????? }
            // n = 7, score = 200
            //   eb09                 | jmp                 0xb
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   68a7000000           | push                0xa7
            //   68a4000000           | push                0xa4
            //   6a22                 | push                0x22
            //   e8????????           |                     

        $sequence_3 = { f6401408 743e 83790400 7538 3bcd 742d 8b4110 }
            // n = 7, score = 200
            //   f6401408             | test                byte ptr [eax + 0x14], 8
            //   743e                 | je                  0x40
            //   83790400             | cmp                 dword ptr [ecx + 4], 0
            //   7538                 | jne                 0x3a
            //   3bcd                 | cmp                 ecx, ebp
            //   742d                 | je                  0x2f
            //   8b4110               | mov                 eax, dword ptr [ecx + 0x10]

        $sequence_4 = { 8b450c 895ddc 8b5d08 2bdf 1bc1 8b4ddc 8945f0 }
            // n = 7, score = 200
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   895ddc               | mov                 dword ptr [ebp - 0x24], ebx
            //   8b5d08               | mov                 ebx, dword ptr [ebp + 8]
            //   2bdf                 | sub                 ebx, edi
            //   1bc1                 | sbb                 eax, ecx
            //   8b4ddc               | mov                 ecx, dword ptr [ebp - 0x24]
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax

        $sequence_5 = { 8945fc 8d7e10 51 51 57 8945f0 e8???????? }
            // n = 7, score = 200
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   8d7e10               | lea                 edi, [esi + 0x10]
            //   51                   | push                ecx
            //   51                   | push                ecx
            //   57                   | push                edi
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   e8????????           |                     

        $sequence_6 = { b9d7505e03 2bc8 83f901 7234 2b1f 8d7001 8bc3 }
            // n = 7, score = 200
            //   b9d7505e03           | mov                 ecx, 0x35e50d7
            //   2bc8                 | sub                 ecx, eax
            //   83f901               | cmp                 ecx, 1
            //   7234                 | jb                  0x36
            //   2b1f                 | sub                 ebx, dword ptr [edi]
            //   8d7001               | lea                 esi, [eax + 1]
            //   8bc3                 | mov                 eax, ebx

        $sequence_7 = { ff742420 52 e8???????? 83c414 85c0 7422 5f }
            // n = 7, score = 200
            //   ff742420             | push                dword ptr [esp + 0x20]
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   85c0                 | test                eax, eax
            //   7422                 | je                  0x24
            //   5f                   | pop                 edi

        $sequence_8 = { e8???????? 83c40c 85d2 7f06 7ce5 85c0 72e1 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   85d2                 | test                edx, edx
            //   7f06                 | jg                  8
            //   7ce5                 | jl                  0xffffffe7
            //   85c0                 | test                eax, eax
            //   72e1                 | jb                  0xffffffe3

        $sequence_9 = { 8bd7 8d4201 8945f0 8a02 42 84c0 75f9 }
            // n = 7, score = 200
            //   8bd7                 | mov                 edx, edi
            //   8d4201               | lea                 eax, [edx + 1]
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   8a02                 | mov                 al, byte ptr [edx]
            //   42                   | inc                 edx
            //   84c0                 | test                al, al
            //   75f9                 | jne                 0xfffffffb

    condition:
        7 of them and filesize < 19405824
}