rule win_bka_trojaner_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.bka_trojaner."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bka_trojaner"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 894c2438 897c242c 897c2430 89542424 0f84c0010000 3bdf }
            // n = 6, score = 100
            //   894c2438             | mov                 dword ptr [esp + 0x38], ecx
            //   897c242c             | mov                 dword ptr [esp + 0x2c], edi
            //   897c2430             | mov                 dword ptr [esp + 0x30], edi
            //   89542424             | mov                 dword ptr [esp + 0x24], edx
            //   0f84c0010000         | je                  0x1c6
            //   3bdf                 | cmp                 ebx, edi

        $sequence_1 = { 756b 837b1c00 7565 a1???????? }
            // n = 4, score = 100
            //   756b                 | jne                 0x6d
            //   837b1c00             | cmp                 dword ptr [ebx + 0x1c], 0
            //   7565                 | jne                 0x67
            //   a1????????           |                     

        $sequence_2 = { 6a00 8d44246c 50 56 ffd3 8b4d74 50 }
            // n = 7, score = 100
            //   6a00                 | push                0
            //   8d44246c             | lea                 eax, [esp + 0x6c]
            //   50                   | push                eax
            //   56                   | push                esi
            //   ffd3                 | call                ebx
            //   8b4d74               | mov                 ecx, dword ptr [ebp + 0x74]
            //   50                   | push                eax

        $sequence_3 = { 8d8170ffffff 83ec10 33d2 85c0 7410 }
            // n = 5, score = 100
            //   8d8170ffffff         | lea                 eax, [ecx - 0x90]
            //   83ec10               | sub                 esp, 0x10
            //   33d2                 | xor                 edx, edx
            //   85c0                 | test                eax, eax
            //   7410                 | je                  0x12

        $sequence_4 = { 6a00 50 894638 ff15???????? 8b4604 }
            // n = 5, score = 100
            //   6a00                 | push                0
            //   50                   | push                eax
            //   894638               | mov                 dword ptr [esi + 0x38], eax
            //   ff15????????         |                     
            //   8b4604               | mov                 eax, dword ptr [esi + 4]

        $sequence_5 = { 6a00 8d44246c 50 56 ffd3 }
            // n = 5, score = 100
            //   6a00                 | push                0
            //   8d44246c             | lea                 eax, [esp + 0x6c]
            //   50                   | push                eax
            //   56                   | push                esi
            //   ffd3                 | call                ebx

        $sequence_6 = { 85c0 7cd1 8b07 8b08 }
            // n = 4, score = 100
            //   85c0                 | test                eax, eax
            //   7cd1                 | jl                  0xffffffd3
            //   8b07                 | mov                 eax, dword ptr [edi]
            //   8b08                 | mov                 ecx, dword ptr [eax]

        $sequence_7 = { 89842460080000 8d442420 50 68???????? 68???????? 33db 56 }
            // n = 7, score = 100
            //   89842460080000       | mov                 dword ptr [esp + 0x860], eax
            //   8d442420             | lea                 eax, [esp + 0x20]
            //   50                   | push                eax
            //   68????????           |                     
            //   68????????           |                     
            //   33db                 | xor                 ebx, ebx
            //   56                   | push                esi

        $sequence_8 = { 6a0c 68???????? e8???????? c745e4d0c64000 817de4d0c64000 }
            // n = 5, score = 100
            //   6a0c                 | push                0xc
            //   68????????           |                     
            //   e8????????           |                     
            //   c745e4d0c64000       | mov                 dword ptr [ebp - 0x1c], 0x40c6d0
            //   817de4d0c64000       | cmp                 dword ptr [ebp - 0x1c], 0x40c6d0

        $sequence_9 = { 8b542448 894104 8b44244c 895108 8b542464 }
            // n = 5, score = 100
            //   8b542448             | mov                 edx, dword ptr [esp + 0x48]
            //   894104               | mov                 dword ptr [ecx + 4], eax
            //   8b44244c             | mov                 eax, dword ptr [esp + 0x4c]
            //   895108               | mov                 dword ptr [ecx + 8], edx
            //   8b542464             | mov                 edx, dword ptr [esp + 0x64]

    condition:
        7 of them and filesize < 221184
}