rule win_blackcoffee_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.blackcoffee."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.blackcoffee"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? 89460c eb03 897e0c 53 ff15???????? 8bc6 }
            // n = 7, score = 200
            //   ff15????????         |                     
            //   89460c               | mov                 dword ptr [esi + 0xc], eax
            //   eb03                 | jmp                 5
            //   897e0c               | mov                 dword ptr [esi + 0xc], edi
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   8bc6                 | mov                 eax, esi

        $sequence_1 = { ff75b8 e8???????? 89460c ff15???????? 894610 8d8534ffffff }
            // n = 6, score = 200
            //   ff75b8               | push                dword ptr [ebp - 0x48]
            //   e8????????           |                     
            //   89460c               | mov                 dword ptr [esi + 0xc], eax
            //   ff15????????         |                     
            //   894610               | mov                 dword ptr [esi + 0x10], eax
            //   8d8534ffffff         | lea                 eax, [ebp - 0xcc]

        $sequence_2 = { 57 8bf0 ff7508 8d450c 50 8d4604 50 }
            // n = 7, score = 200
            //   57                   | push                edi
            //   8bf0                 | mov                 esi, eax
            //   ff7508               | push                dword ptr [ebp + 8]
            //   8d450c               | lea                 eax, [ebp + 0xc]
            //   50                   | push                eax
            //   8d4604               | lea                 eax, [esi + 4]
            //   50                   | push                eax

        $sequence_3 = { f3ab 8d8568ffffff 33f6 50 c745fc04010000 c78568ffffff94000000 }
            // n = 6, score = 200
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   8d8568ffffff         | lea                 eax, [ebp - 0x98]
            //   33f6                 | xor                 esi, esi
            //   50                   | push                eax
            //   c745fc04010000       | mov                 dword ptr [ebp - 4], 0x104
            //   c78568ffffff94000000     | mov    dword ptr [ebp - 0x98], 0x94

        $sequence_4 = { 6a1c 6a40 aa ff15???????? 8bf0 8b4508 }
            // n = 6, score = 200
            //   6a1c                 | push                0x1c
            //   6a40                 | push                0x40
            //   aa                   | stosb               byte ptr es:[edi], al
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]

        $sequence_5 = { 8bec 81ec08020000 80a5f8feffff00 57 }
            // n = 4, score = 200
            //   8bec                 | mov                 ebp, esp
            //   81ec08020000         | sub                 esp, 0x208
            //   80a5f8feffff00       | and                 byte ptr [ebp - 0x108], 0
            //   57                   | push                edi

        $sequence_6 = { 59 8b35???????? 59 bf000000a0 57 }
            // n = 5, score = 200
            //   59                   | pop                 ecx
            //   8b35????????         |                     
            //   59                   | pop                 ecx
            //   bf000000a0           | mov                 edi, 0xa0000000
            //   57                   | push                edi

        $sequence_7 = { 8d4628 50 ffd3 8b45f4 }
            // n = 4, score = 200
            //   8d4628               | lea                 eax, [esi + 0x28]
            //   50                   | push                eax
            //   ffd3                 | call                ebx
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]

        $sequence_8 = { 8955f8 ff750c 6a00 ff15???????? 85c0 5f 741d }
            // n = 7, score = 200
            //   8955f8               | mov                 dword ptr [ebp - 8], edx
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   5f                   | pop                 edi
            //   741d                 | je                  0x1f

        $sequence_9 = { 8365fc00 83c010 6a04 50 8d45fc 50 }
            // n = 6, score = 200
            //   8365fc00             | and                 dword ptr [ebp - 4], 0
            //   83c010               | add                 eax, 0x10
            //   6a04                 | push                4
            //   50                   | push                eax
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax

    condition:
        7 of them and filesize < 118784
}