rule win_blackmagic_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.blackmagic."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.blackmagic"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488bcb e8???????? 90 41b940000000 458d41e2 488bd7 488bcb }
            // n = 7, score = 100
            //   488bcb               | je                  0x14a3
            //   e8????????           |                     
            //   90                   | dec                 eax
            //   41b940000000         | mov                 ebx, dword ptr [ebp - 0x69]
            //   458d41e2             | inc                 esp
            //   488bd7               | movzx               eax, byte ptr [esi]
            //   488bcb               | dec                 eax

        $sequence_1 = { 4883c430 5f c3 b914000000 e8???????? 33c0 488b5c2440 }
            // n = 7, score = 100
            //   4883c430             | add                 eax, ecx
            //   5f                   | jmp                 0x96
            //   c3                   | inc                 ecx
            //   b914000000           | mov                 eax, dword ptr [eax + 0x34]
            //   e8????????           |                     
            //   33c0                 | inc                 esp
            //   488b5c2440           | mov                 ecx, eax

        $sequence_2 = { ba01000000 488bc8 41ff10 90 488b842490020000 4885c0 7433 }
            // n = 7, score = 100
            //   ba01000000           | inc                 ebp
            //   488bc8               | xor                 eax, eax
            //   41ff10               | dec                 eax
            //   90                   | mov                 edx, eax
            //   488b842490020000     | dec                 eax
            //   4885c0               | lea                 ecx, [esp + 0x50]
            //   7433                 | nop                 

        $sequence_3 = { 48895890 48895898 885888 48895880 885c2420 488b02 4c8d4c2430 }
            // n = 7, score = 100
            //   48895890             | test                dword ptr [ecx + 0xb8], 0x100
            //   48895898             | dec                 esp
            //   885888               | mov                 esi, ecx
            //   48895880             | dec                 eax
            //   885c2420             | mov                 eax, dword ptr [ecx]
            //   488b02               | dec                 eax
            //   4c8d4c2430           | mov                 dword ptr [esp + 0x70], ebx

        $sequence_4 = { 488bce e8???????? 4180e603 ba01000000 488bce 41c0e604 483bfa }
            // n = 7, score = 100
            //   488bce               | lea                 edx, [ebp + 0x78]
            //   e8????????           |                     
            //   4180e603             | dec                 eax
            //   ba01000000           | cmp                 dword ptr [ebp + 0x90], 0x10
            //   488bce               | dec                 eax
            //   41c0e604             | cmovae              edx, dword ptr [ebp + 0x78]
            //   483bfa               | dec                 ecx

        $sequence_5 = { 8945b7 498b4e08 48894dbf 488b07 488945cf 4585ff }
            // n = 6, score = 100
            //   8945b7               | dec                 eax
            //   498b4e08             | mov                 edx, dword ptr [ebx + edx*8 + 0x76980]
            //   48894dbf             | mov                 cl, byte ptr [eax]
            //   488b07               | dec                 eax
            //   488945cf             | lea                 ebx, [0x480bf]
            //   4585ff               | dec                 eax

        $sequence_6 = { 440f42c1 488b4b60 e8???????? 488b4360 488b4808 48894b70 e9???????? }
            // n = 7, score = 100
            //   440f42c1             | dec                 eax
            //   488b4b60             | mov                 dword ptr [esi], eax
            //   e8????????           |                     
            //   488b4360             | dec                 eax
            //   488b4808             | mov                 eax, esi
            //   48894b70             | int3                
            //   e9????????           |                     

        $sequence_7 = { 488d0dd58f0200 48890b 488d5308 33c9 48890a 48894a08 488d4808 }
            // n = 7, score = 100
            //   488d0dd58f0200       | mov                 dword ptr [esp + 0x30], ecx
            //   48890b               | mov                 dword ptr [esp + 0x48], 6
            //   488d5308             | dec                 eax
            //   33c9                 | mov                 dword ptr [esp + 0x68], 0xf
            //   48890a               | dec                 eax
            //   48894a08             | mov                 dword ptr [esp + 0x60], 0
            //   488d4808             | dec                 eax

        $sequence_8 = { 4183f805 757c 8b470c 458d487a c744243001000000 4c8d05ed2c0200 89442428 }
            // n = 7, score = 100
            //   4183f805             | nop                 
            //   757c                 | nop                 
            //   8b470c               | dec                 esp
            //   458d487a             | lea                 eax, [0x7ebed]
            //   c744243001000000     | dec                 eax
            //   4c8d05ed2c0200       | mov                 edx, eax
            //   89442428             | dec                 eax

        $sequence_9 = { 4533c0 e8???????? 90 488d0535330300 488903 488bc3 4883c430 }
            // n = 7, score = 100
            //   4533c0               | lea                 eax, [0x7c2cb]
            //   e8????????           |                     
            //   90                   | dec                 eax
            //   488d0535330300       | mov                 dword ptr [esp + 0x50], eax
            //   488903               | dec                 eax
            //   488bc3               | lea                 edx, [0x91d97]
            //   4883c430             | dec                 eax

    condition:
        7 of them and filesize < 1416192
}